package com.artear.tools.preferences

import android.content.SharedPreferences

class BooleanPreference @JvmOverloads
internal constructor(preferences: SharedPreferences, key: String,
                     defaultValue: Boolean = false) :
        WrapperPreference<Boolean>(preferences, key, defaultValue) {

    override fun get(): Boolean? {
        var default = false
        if (defaultValue != null) default = defaultValue
        return preferences.getBoolean(key, default)
    }

    override fun set(value: Boolean?) {
        var newValue = false
        if (value != null) newValue = value
        preferences.edit().putBoolean(key, newValue).apply()
    }

}
