/*
 * Copyright 2018 Artear S.A.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.artear.tools.error

import com.artear.tools.exception.BadResponseException
import com.artear.tools.exception.InvalidSizeException
import com.artear.tools.exception.NoInternetConnectionException

object NestErrorFactory {

    fun create(e: Throwable): NestError {

        val message = e.message

        val type: NestErrorType = when (e) {
            is NoInternetConnectionException -> NestErrorType.CONNECTION
            is BadResponseException -> NestErrorType.SERVER
            is InvalidSizeException -> NestErrorType.NO_CONTENT
            else -> NestErrorType.UNKNOWN
        }

        return NestError(type, message, e)
    }

}
