/*
 * Copyright 2018 Artear S.A.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.artear.tools

import android.content.Context
import android.content.pm.ApplicationInfo
import android.content.pm.PackageManager
import android.os.Build

class AndroidUtils {

    companion object {

        /**
         * @param attr R.attr.actionBarSize
         */
        fun getToolbarHeight(context: Context, attr: Int): Int {
            val styledAttributes = context.theme.obtainStyledAttributes(
                    intArrayOf(attr))
            val toolbarHeight = styledAttributes.getDimension(0, 0f).toInt()
            styledAttributes.recycle()

            return toolbarHeight
        }


        // -------------- Version --------------
        fun isLollipop(): Boolean {
            return Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP
        }

        fun isMarshmallow(): Boolean {
            return Build.VERSION.SDK_INT >= Build.VERSION_CODES.M
        }
        // -------------- Version --------------


        // --------------- Debug ---------------
        fun isDebugBuild(context: Context): Boolean {
            return 0 != context.applicationInfo.flags and ApplicationInfo.FLAG_DEBUGGABLE
        }
        // --------------- Debug ---------------


        // -------------- Storage --------------
        /**
         * Checks if the application is installed on the SD card.
         *
         * @return `true` if the application is installed on the sd card
         */
        fun isInstalledOnSdCard(context: Context): Boolean {
            val pm = context.packageManager
            return try {
                val pi = pm.getPackageInfo(context.packageName, 0)
                val ai = pi.applicationInfo
                ai.flags and ApplicationInfo.FLAG_EXTERNAL_STORAGE == ApplicationInfo.FLAG_EXTERNAL_STORAGE
            } catch (e: PackageManager.NameNotFoundException) {
                false
            }
        }
        // -------------- Storage --------------


        fun getStatusBarHeight(context: Context): Int {
            var result = 0
            val resourceId = context.resources.getIdentifier("status_bar_height", "dimen", "android")
            if (resourceId > 0) {
                result = context.resources.getDimensionPixelSize(resourceId)
            }
            return result
        }


    }
}