/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.art.uilibrary.R;
import java.text.MessageFormat;

public class Toaster {
    private static Toaster sInstance;
    private final Context mContext;
    private final Handler mHandler;
    public static final int SYSTEM = 0;
    public static final int CUSTOM = 1;
    public static final int WARN = 2;
    public static final int LONG = 3;
    public static final int FAIL = 0;
    public static final int SUCCESS = 1;

    private Toaster(Context context) {
        this.mContext = context;
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        Toast.makeText((Context)Toaster.this.mContext, (CharSequence)((String)msg.obj), (int)msg.arg1).show();
                        break;
                    }
                    case 1: {
                        Object res = msg.obj;
                        View layout2 = LayoutInflater.from((Context)Toaster.this.mContext).inflate(R.layout.toast_custom_view, null);
                        TextView text = (TextView)layout2.findViewById(R.id.text);
                        if (res instanceof Integer) {
                            text.setText(((Integer)res).intValue());
                        } else {
                            text.setText((CharSequence)res.toString());
                        }
                        Toast toast = new Toast(Toaster.this.mContext);
                        toast.setGravity(16, 0, 0);
                        toast.setDuration(1);
                        toast.setView(layout2);
                        toast.show();
                        break;
                    }
                    case 2: {
                        Object res = msg.obj;
                        int status = msg.arg1;
                        View layout3 = LayoutInflater.from((Context)Toaster.this.mContext).inflate(R.layout.toast_warn_view, null);
                        TextView text = (TextView)layout3.findViewById(R.id.text);
                        ImageView imageView = (ImageView)layout3.findViewById(R.id.image);
                        if (res instanceof Integer) {
                            text.setText(((Integer)res).intValue());
                        } else {
                            text.setText((CharSequence)res.toString());
                        }
                        if (status == 0) {
                            imageView.setImageResource(R.mipmap.icon_warn);
                        } else {
                            imageView.setImageResource(R.mipmap.icon_ok);
                        }
                        Toast toast = new Toast(Toaster.this.mContext);
                        toast.setGravity(16, 0, 0);
                        toast.setView(layout3);
                        toast.show();
                        toast.setDuration(0);
                        break;
                    }
                    case 3: {
                        Toast toast = Toast.makeText((Context)Toaster.this.mContext, (CharSequence)"", (int)1);
                        String message = "";
                        if (msg.obj instanceof String) {
                            message = (String)msg.obj;
                        } else if (msg.obj instanceof Integer) {
                            message = Toaster.this.mContext.getString(((Integer)msg.obj).intValue());
                        }
                        toast.setText((CharSequence)message);
                        toast.show();
                    }
                }
            }
        };
    }

    public static void init(Context context) {
        if (sInstance != null) {
            throw new IllegalStateException("Toaster has been inited.");
        }
        sInstance = new Toaster(context);
    }

    public static Toaster getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("Toaster has not been inited.");
        }
        return sInstance;
    }

    public void showToast(Object resContent) {
        if (resContent == null) {
            return;
        }
        this.showToast(resContent, 0);
    }

    public void showToast(Object resContent, int duration) {
        if (resContent == null) {
            return;
        }
        Object obj = resContent;
        if (resContent instanceof Integer) {
            obj = this.mContext.getString(((Integer)resContent).intValue());
        }
        Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)obj);
        msg.what = 0;
        msg.arg1 = duration;
        msg.sendToTarget();
    }

    public void showToast(int formatRes, Object[] params) {
        String obj = MessageFormat.format(this.mContext.getString(formatRes), params);
        Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)obj);
        msg.what = 0;
        msg.arg1 = 0;
        msg.sendToTarget();
    }

    public void showCustomToast(Object toastMessage) {
        Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)toastMessage);
        msg.what = 1;
        msg.sendToTarget();
    }

    public void showWarnToast(int status, Object toastMessage) {
        Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)toastMessage);
        msg.arg1 = status;
        msg.what = 2;
        msg.sendToTarget();
    }

    public void showLongToast(Object toastMessage) {
        Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)toastMessage);
        msg.what = 3;
        msg.sendToTarget();
    }
}

