/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.clipphotoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.art.uilibrary.clipphotoview.ClipPhotoCircleView;
import com.art.uilibrary.clipphotoview.ClipPhotoRectView;
import com.art.uilibrary.clipphotoview.ClipPhotoView;

public class ClipPhotoLayout
extends FrameLayout {
    private ClipPhotoCircleView mCircleView;
    private ClipPhotoRectView mRectView;
    private ClipPhotoView mPhotoView;
    public static final int CIRCLE = 0;
    public static final int RECT = 1;

    public ClipPhotoView getmPhotoView() {
        return this.mPhotoView;
    }

    public ClipPhotoLayout(Context context) {
        this(context, null);
    }

    public ClipPhotoLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClipPhotoLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void addClipView(int type) {
        if (type == 0) {
            this.setCircle();
        } else if (type == 1) {
            this.setRect();
        } else {
            this.setRect();
        }
    }

    private void setRect() {
        this.mRectView = new ClipPhotoRectView(this.getContext());
        this.mPhotoView = new ClipPhotoView(this.getContext());
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -1);
        this.addView((View)this.mPhotoView, (ViewGroup.LayoutParams)lp);
        this.addView(this.mRectView, (ViewGroup.LayoutParams)lp);
    }

    private void setCircle() {
        this.mCircleView = new ClipPhotoCircleView(this.getContext());
        this.mRectView = new ClipPhotoRectView(this.getContext());
        this.mPhotoView = new ClipPhotoView(this.getContext());
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -1);
        this.addView((View)this.mPhotoView, (ViewGroup.LayoutParams)lp);
        this.addView(this.mCircleView, (ViewGroup.LayoutParams)lp);
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mPhotoView.setImageDrawable(drawable2);
    }

    public void setImageDrawable(int resId) {
        this.setImageDrawable(this.getContext().getResources().getDrawable(resId));
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.mPhotoView.setImageBitmap(bitmap);
    }

    public String clipBitmap() {
        return this.mPhotoView.clip();
    }
}

