/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import androidx.viewpager.widget.ViewPager;

public class ZoomImageView
extends ImageView
implements ViewTreeObserver.OnGlobalLayoutListener,
ScaleGestureDetector.OnScaleGestureListener,
View.OnTouchListener {
    private boolean mOnce = false;
    private float mInitScale;
    private float mMidScale;
    private float mMaxScale;
    private Matrix mScaleMatrix = new Matrix();
    private ScaleGestureDetector mScaleGestureDetector = null;
    private int mLastPointerCount;
    private float mLastX;
    private float mLastY;
    private int mTouchSlop;
    private boolean isCanDrag;
    private boolean isCheckLeftAndRight;
    private boolean isCheckTopAndBottom;
    private GestureDetector mGestureDetector = null;
    private boolean isAutoScale;

    public ZoomImageView(Context context) {
        this(context, null);
    }

    public ZoomImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ZoomImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.setOnTouchListener(this);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                if (ZoomImageView.this.isAutoScale) {
                    return true;
                }
                float x = e.getX();
                float y = e.getY();
                if (ZoomImageView.this.getCurrentScale() < ZoomImageView.this.mMidScale) {
                    ZoomImageView.this.postDelayed(new AutoScaleRunnable(ZoomImageView.this.mMidScale, x, y), 16L);
                    ZoomImageView.this.isAutoScale = true;
                } else {
                    ZoomImageView.this.postDelayed(new AutoScaleRunnable(ZoomImageView.this.mInitScale, x, y), 16L);
                    ZoomImageView.this.isAutoScale = true;
                }
                return true;
            }
        });
    }

    public void onGlobalLayout() {
        if (!this.mOnce) {
            int width = this.getWidth();
            int height = this.getHeight();
            Drawable drawable2 = this.getDrawable();
            if (drawable2 == null) {
                return;
            }
            int drawableWidth = drawable2.getIntrinsicWidth();
            int drawableHeight = drawable2.getIntrinsicHeight();
            float scale = 1.0f;
            if (drawableWidth > width && drawableHeight <= height) {
                scale = (float)width * 1.0f / (float)drawableWidth;
            }
            if (drawableWidth <= width && drawableHeight > height) {
                scale = (float)height * 1.0f / (float)drawableHeight;
            }
            if (drawableWidth > width && drawableHeight > height) {
                scale = Math.min((float)width * 1.0f / (float)drawableWidth, (float)height * 1.0f / (float)drawableHeight);
            }
            if (drawableWidth < width && drawableHeight < height) {
                scale = Math.min((float)width * 1.0f / (float)drawableWidth, (float)height * 1.0f / (float)drawableHeight);
            }
            this.mInitScale = scale;
            this.mMidScale = this.mInitScale * 2.0f;
            this.mMaxScale = this.mInitScale * 4.0f;
            int dx = width / 2 - drawableWidth / 2;
            int dy = height / 2 - drawableHeight / 2;
            this.mScaleMatrix.postTranslate((float)dx, (float)dy);
            this.mScaleMatrix.postScale(this.mInitScale, this.mInitScale, (float)(width / 2), (float)(height / 2));
            this.setImageMatrix(this.mScaleMatrix);
            this.mOnce = true;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    public float getCurrentScale() {
        float[] values = new float[9];
        this.mScaleMatrix.getValues(values);
        return values[0];
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float scale = this.getCurrentScale();
        float scaleFactor = detector.getScaleFactor();
        if (this.getDrawable() == null) {
            return true;
        }
        if (scale < this.mMaxScale && scaleFactor > 1.0f || scale > this.mInitScale && scaleFactor < 1.0f) {
            if (scale * scaleFactor < this.mInitScale) {
                scaleFactor = this.mInitScale / scale;
            }
            if (scale * scaleFactor > this.mMaxScale) {
                scaleFactor = this.mMaxScale / scale;
            }
        }
        this.mScaleMatrix.postScale(scaleFactor, scaleFactor, detector.getFocusX(), detector.getFocusY());
        this.checkBorderAndCenterWhenScale();
        this.setImageMatrix(this.mScaleMatrix);
        return true;
    }

    private RectF getMatrixRectF() {
        Matrix matrix = this.mScaleMatrix;
        RectF rectF = new RectF();
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            rectF.set(0.0f, 0.0f, (float)drawable2.getIntrinsicWidth(), (float)drawable2.getIntrinsicHeight());
            matrix.mapRect(rectF);
        }
        return rectF;
    }

    private void checkBorderAndCenterWhenScale() {
        RectF rect = this.getMatrixRectF();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int width = this.getWidth();
        int height = this.getHeight();
        if (rect.width() >= (float)width) {
            if (rect.left > 0.0f) {
                deltaX = -rect.left;
            }
            if (rect.right < (float)width) {
                deltaX = (float)width - rect.right;
            }
        }
        if (rect.height() >= (float)height) {
            if (rect.top > 0.0f) {
                deltaY = -rect.top;
            }
            if (rect.bottom < (float)height) {
                deltaY = (float)height - rect.bottom;
            }
        }
        if (rect.width() < (float)width) {
            deltaX = (float)width / 2.0f - rect.right + rect.width() / 2.0f;
        }
        if (rect.height() < (float)height) {
            deltaY = (float)height / 2.0f - rect.bottom + rect.height() / 2.0f;
        }
        this.mScaleMatrix.postTranslate(deltaX, deltaY);
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mGestureDetector.onTouchEvent(event)) {
            return true;
        }
        this.mScaleGestureDetector.onTouchEvent(event);
        float x = 0.0f;
        float y = 0.0f;
        int pointerCount = event.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            x += event.getX(i);
            y += event.getY(i);
        }
        x /= (float)pointerCount;
        y /= (float)pointerCount;
        if (this.mLastPointerCount != pointerCount) {
            this.isCanDrag = false;
            this.mLastX = x;
            this.mLastY = y;
        }
        this.mLastPointerCount = pointerCount;
        RectF rectF = this.getMatrixRectF();
        switch (event.getAction()) {
            case 0: {
                if (!((double)rectF.width() > (double)this.getWidth() + 0.01) && !((double)rectF.height() > (double)this.getHeight() + 0.01) || !(this.getParent() instanceof ViewPager)) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                if (((double)rectF.width() > (double)this.getWidth() + 0.01 || (double)rectF.height() > (double)this.getHeight() + 0.01) && this.getParent() instanceof ViewPager) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                float deltaX = x - this.mLastX;
                float deltaY = y - this.mLastY;
                if (!this.isCanDrag) {
                    this.isCanDrag = this.isMoveAction(deltaX, deltaY);
                }
                if (this.isCanDrag && this.getDrawable() != null) {
                    this.isCheckLeftAndRight = true;
                    this.isCheckTopAndBottom = true;
                    if (rectF.width() < (float)this.getWidth()) {
                        this.isCheckLeftAndRight = false;
                        deltaX = 0.0f;
                    }
                    if (rectF.height() < (float)this.getHeight()) {
                        this.isCheckTopAndBottom = false;
                        deltaY = 0.0f;
                    }
                    this.mScaleMatrix.postTranslate(deltaX, deltaY);
                    this.checkBorderWhenTranslate();
                    this.setImageMatrix(this.mScaleMatrix);
                }
                this.mLastX = x;
                this.mLastY = y;
                break;
            }
            case 1: {
                this.mLastPointerCount = 0;
                break;
            }
            case 3: {
                this.mLastPointerCount = 0;
            }
        }
        return true;
    }

    private void checkBorderWhenTranslate() {
        RectF rectF = this.getMatrixRectF();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int width = this.getWidth();
        int height = this.getHeight();
        if (rectF.top > 0.0f && this.isCheckTopAndBottom) {
            deltaY = -rectF.top;
        }
        if (rectF.bottom < (float)height && this.isCheckTopAndBottom) {
            deltaY = (float)height - rectF.bottom;
        }
        if (rectF.left > 0.0f && this.isCheckLeftAndRight) {
            deltaX = -rectF.left;
        }
        if (rectF.right < (float)width && this.isCheckLeftAndRight) {
            deltaX = (float)width - rectF.right;
        }
        this.mScaleMatrix.postTranslate(deltaX, deltaY);
    }

    private boolean isMoveAction(float deltaX, float deltaY) {
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY) > (double)this.mTouchSlop;
    }

    private class AutoScaleRunnable
    implements Runnable {
        private float mTargetScale;
        private float x;
        private float y;
        private final float BIGGER = 1.07f;
        private final float SMALL = 0.93f;
        private float tmpScale;

        public AutoScaleRunnable(float mTargetScale, float x, float y) {
            this.mTargetScale = mTargetScale;
            this.x = x;
            this.y = y;
            if (ZoomImageView.this.getCurrentScale() < mTargetScale) {
                this.tmpScale = 1.07f;
            } else if (ZoomImageView.this.getCurrentScale() > mTargetScale) {
                this.tmpScale = 0.93f;
            }
        }

        @Override
        public void run() {
            ZoomImageView.this.mScaleMatrix.postScale(this.tmpScale, this.tmpScale, this.x, this.y);
            ZoomImageView.this.checkBorderAndCenterWhenScale();
            ZoomImageView.this.setImageMatrix(ZoomImageView.this.mScaleMatrix);
            float currentScale = ZoomImageView.this.getCurrentScale();
            if (this.tmpScale > 1.0f && currentScale < this.mTargetScale || this.tmpScale < 1.0f && currentScale > this.mTargetScale) {
                ZoomImageView.this.postDelayed(this, 16L);
            } else {
                float scale = this.mTargetScale / currentScale;
                ZoomImageView.this.mScaleMatrix.postScale(scale, scale, this.x, this.y);
                ZoomImageView.this.checkBorderAndCenterWhenScale();
                ZoomImageView.this.setImageMatrix(ZoomImageView.this.mScaleMatrix);
                ZoomImageView.this.isAutoScale = false;
            }
        }
    }
}

