/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

@Deprecated
public class DividerGridItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private Paint mPaint = new Paint(1);
    private static final int[] ATTRS = new int[]{16843284};
    private int mDividerHeight = 10;

    public DividerGridItemDecoration(Context context) {
        this.mPaint.setColor(0);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mDivider = new ColorDrawable(0xFFFFFF);
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        this.drawHorizontal(c, parent);
        this.drawVertical(c, parent);
    }

    public void drawHorizontal(Canvas c, RecyclerView parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int left = child.getLeft() - params.leftMargin;
            int right = child.getRight() + params.rightMargin + this.mDivider.getIntrinsicWidth();
            int top = child.getBottom() + params.bottomMargin;
            int bottom = top + this.mDivider.getIntrinsicHeight() + this.mDividerHeight;
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
            Rect rect = new Rect(left, top, right, bottom);
            c.drawRect(rect, this.mPaint);
        }
    }

    public void drawVertical(Canvas c, RecyclerView parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getTop() - params.topMargin;
            int bottom = child.getBottom() + params.bottomMargin;
            int left = child.getRight() + params.rightMargin;
            int right = left + this.mDivider.getIntrinsicWidth() + this.mDividerHeight;
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
            Rect rect = new Rect(left, top, right, bottom);
            c.drawRect(rect, this.mPaint);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        int itemPosition = parent.getChildAdapterPosition(view);
        int spanCount = this.getSpanCount(parent);
        int childCount = parent.getAdapter().getItemCount();
        if (this.isLastRaw(parent, itemPosition, spanCount, childCount)) {
            outRect.set(0, 0, this.mDivider.getIntrinsicWidth(), 0);
        } else if (this.isLastColumn(parent, itemPosition, spanCount, childCount)) {
            outRect.set(0, 0, 0, this.mDivider.getIntrinsicHeight());
        } else {
            outRect.set(0, 0, this.mDivider.getIntrinsicWidth(), this.mDivider.getIntrinsicHeight());
        }
    }

    private int getSpanCount(RecyclerView parent) {
        int spanCount = -1;
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            spanCount = ((GridLayoutManager)layoutManager).getSpanCount();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            spanCount = ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        }
        return spanCount;
    }

    private boolean isLastColumn(RecyclerView parent, int pos, int spanCount, int childCount) {
        int orientation;
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        return layoutManager instanceof GridLayoutManager ? (pos + 1) % spanCount == 0 : layoutManager instanceof StaggeredGridLayoutManager && ((orientation = ((StaggeredGridLayoutManager)layoutManager).getOrientation()) == 1 ? (pos + 1) % spanCount == 0 : pos >= (childCount -= childCount % spanCount));
    }

    private boolean isLastRaw(RecyclerView parent, int pos, int spanCount, int childCount) {
        int orientation;
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        return layoutManager instanceof GridLayoutManager ? pos >= (childCount -= childCount % spanCount) : layoutManager instanceof StaggeredGridLayoutManager && ((orientation = ((StaggeredGridLayoutManager)layoutManager).getOrientation()) == 1 ? pos >= (childCount -= childCount % spanCount) : (pos + 1) % spanCount == 0);
    }
}

