/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.pullrefresh;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ScrollView;
import com.art.uilibrary.pullrefresh.ILoadingLayout;
import com.art.uilibrary.pullrefresh.PullToRefreshBase;
import com.art.uilibrary.widget.AutoScrollView;

@SuppressLint(value={"NewApi"})
public class PullToRefreshScrollView
extends PullToRefreshBase<ScrollView> {
    private int stateToSave;

    public PullToRefreshScrollView(Context context) {
        this(context, null);
        this.setOverScrollMode(2);
    }

    public PullToRefreshScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.setOverScrollMode(2);
    }

    public PullToRefreshScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setOverScrollMode(2);
    }

    @Override
    protected ScrollView createRefreshableView(Context context, AttributeSet attrs) {
        return new AutoScrollView(context, attrs);
    }

    @Override
    protected boolean isReadyForPullDown() {
        return ((ScrollView)this.mRefreshableView).getScrollY() == 0;
    }

    @Override
    protected boolean isReadyForPullUp() {
        View scrollViewChild = ((ScrollView)this.mRefreshableView).getChildAt(0);
        if (scrollViewChild != null) {
            int differHeight;
            int childHeight = scrollViewChild.getHeight();
            int viewHeight = this.getHeight();
            int scrollY = ((ScrollView)this.mRefreshableView).getScrollY();
            int result = scrollY - (differHeight = childHeight - viewHeight);
            return result >= 0;
        }
        return false;
    }

    public void setHasMoreData(boolean hasMoreData) {
        if (!hasMoreData && this.getFooterLoadingLayout() != null) {
            this.getFooterLoadingLayout().setState(ILoadingLayout.State.NO_MORE_DATA);
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.stateToSave = this.stateToSave;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            try {
                super.onRestoreInstanceState(state);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.stateToSave = ss.stateToSave;
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        int stateToSave;

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.stateToSave = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.stateToSave);
        }
    }
}

