/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.clipphotoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.ImageView;
import com.art.uilibrary.utils.FileUtils;

public class ClipPhotoView
extends ImageView
implements View.OnTouchListener,
ScaleGestureDetector.OnScaleGestureListener {
    private static final String TAG = ClipPhotoView.class.getSimpleName();
    private static final float MAX_SCALE = 2.0f;
    private float minScale = 1.0f;
    private static final float[] MATRIX_ARR = new float[9];
    private static final int MAX_IMAGE_SIZE = 2000;
    private int mMode = 0;
    private ScaleGestureDetector mScaleDetector;
    private Matrix mMatrix = new Matrix();
    private PointF mPrevPointF = new PointF();
    private int mRadius;
    private boolean firstTime = true;

    public ClipPhotoView(Context context) {
        this(context, null);
    }

    public ClipPhotoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClipPhotoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int screenWidth = metrics.widthPixels;
        this.mRadius = (screenWidth - 200) / 2;
        this.setOnTouchListener(this);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    private void init() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        this.initPosAndScale();
    }

    private void initPosAndScale() {
        if (this.firstTime) {
            Drawable drawable2 = this.getDrawable();
            int width = this.getWidth();
            int height = this.getHeight();
            int dw = drawable2.getIntrinsicWidth();
            int dh = drawable2.getIntrinsicHeight();
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            boolean isScaled = false;
            if (width < this.getDiameter()) {
                scaleX = (float)this.getDiameter() * 1.0f / (float)width;
                isScaled = true;
            }
            if (height < this.getDiameter()) {
                scaleY = (float)this.getDiameter() * 1.0f / (float)height;
                isScaled = true;
            }
            float scale = Math.max(scaleX, scaleY);
            this.minScale = isScaled ? scale : Math.max((float)this.getDiameter() * 1.0f / (float)dw, (float)this.getDiameter() * 1.0f / (float)dh) + 0.01f;
            Log.d((String)TAG, (String)("scale=" + scale));
            this.mMatrix.postScale(scale, scale, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            this.mMatrix.postTranslate((float)((width - dw) / 2), (float)((height - dh) / 2));
            this.setImageMatrix(this.mMatrix);
            this.firstTime = false;
        }
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float scale = this.getScale();
        float scaleFactor = detector.getScaleFactor();
        if (scale >= this.minScale && scaleFactor > 1.0f || scale <= 2.0f && scaleFactor < 1.0f) {
            if (scale * scaleFactor <= this.minScale) {
                scaleFactor = this.minScale / scale;
            } else if (scale * scaleFactor >= 2.0f) {
                scaleFactor = 2.0f / scale;
            }
            this.mMatrix.postScale(scaleFactor, scaleFactor, detector.getFocusX(), detector.getFocusY());
            this.checkTrans();
            this.setImageMatrix(this.mMatrix);
        }
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        this.mMode = 2;
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        this.mMode = 0;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.getDrawable() == null) {
            return false;
        }
        this.mScaleDetector.onTouchEvent(event);
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.mMode = 1;
                this.mPrevPointF.set(event.getX(), event.getY());
                break;
            }
            case 1: {
                this.mMode = 0;
                break;
            }
            case 2: {
                if (this.mMode != 1 || event.getPointerCount() != 1) break;
                float x = event.getX();
                float y = event.getY();
                float dx = event.getX() - this.mPrevPointF.x;
                float dy = event.getY() - this.mPrevPointF.y;
                RectF rectF = this.getMatrixRectF();
                if (rectF.width() <= (float)this.getDiameter()) {
                    dx = 0.0f;
                }
                if (rectF.height() <= (float)this.getDiameter()) {
                    dy = 0.0f;
                }
                this.mMatrix.postTranslate(dx, dy);
                this.checkTrans();
                this.setImageMatrix(this.mMatrix);
                this.mPrevPointF.set(x, y);
            }
        }
        return true;
    }

    private void checkTrans() {
        RectF rect = this.getMatrixRectF();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int width = this.getWidth();
        int height = this.getHeight();
        int horizontalPadding = (width - this.getDiameter()) / 2;
        int verticalPadding = (height - this.getDiameter()) / 2;
        if ((double)rect.width() + 0.01 >= (double)this.getDiameter()) {
            if (rect.left > (float)horizontalPadding) {
                deltaX = -rect.left + (float)horizontalPadding;
            }
            if (rect.right < (float)(width - horizontalPadding)) {
                deltaX = (float)(width - horizontalPadding) - rect.right;
            }
        }
        if ((double)rect.height() + 0.01 >= (double)this.getDiameter()) {
            if (rect.top > (float)verticalPadding) {
                deltaY = -rect.top + (float)verticalPadding;
            }
            if (rect.bottom < (float)(height - verticalPadding)) {
                deltaY = (float)(height - verticalPadding) - rect.bottom;
            }
        }
        this.mMatrix.postTranslate(deltaX, deltaY);
    }

    public int getDiameter() {
        return this.mRadius * 2;
    }

    private float getScale() {
        return this.getMatrixValue(0);
    }

    private float getMatrixValue(int index) {
        this.mMatrix.getValues(MATRIX_ARR);
        return MATRIX_ARR[index];
    }

    private RectF getMatrixRectF() {
        Matrix matrix = this.mMatrix;
        RectF rect = new RectF();
        Drawable d = this.getDrawable();
        if (null != d) {
            rect.set(0.0f, 0.0f, (float)d.getIntrinsicWidth(), (float)d.getIntrinsicHeight());
            matrix.mapRect(rect);
        }
        return rect;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.init();
    }

    String clip() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        this.draw(canvas);
        int x = (this.getWidth() - this.getDiameter()) / 2;
        int y = (this.getHeight() - this.getDiameter()) / 2;
        Bitmap compressBitmap = FileUtils.compressBitmap(bitmap, 2000);
        bitmap.recycle();
        return FileUtils.saveBitmap(Bitmap.createBitmap((Bitmap)compressBitmap, (int)x, (int)y, (int)this.getDiameter(), (int)this.getDiameter()));
    }

    private static final class Mode {
        private static final int NONE = 0;
        private static final int DRAG = 1;
        private static final int ZOOM = 2;

        private Mode() {
        }
    }
}

