/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.art.uilibrary.R;
import java.text.MessageFormat;

public class Toaster {
    private static Toaster sInstance;
    private final Context mContext;
    private final Handler mHandler;
    private final int duration = 0;
    public static final int SYSTEM = 0;
    public static final int CUSTOM = 1;
    public static final int WARN = 2;
    public static final int SUCCESS = 1;
    public static final int FAIL = 0;

    private Toaster(Context context) {
        this.mContext = context;
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        Toast.makeText((Context)Toaster.this.mContext, (CharSequence)((String)msg.obj), (int)0).show();
                        break;
                    }
                    case 1: {
                        Toaster.this.customToastShow(msg.obj);
                        break;
                    }
                    case 2: {
                        Toaster.this.warnToastShow(msg.arg1, msg.obj);
                    }
                }
            }
        };
    }

    public static void init(Context context) {
        if (sInstance != null) {
            throw new IllegalStateException("Toaster has been inited.");
        }
        sInstance = new Toaster(context);
    }

    public static Toaster getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("Toaster has not been inited.");
        }
        return sInstance;
    }

    public void showToast(Object resContent) {
        if (resContent == null) {
            return;
        }
        if (resContent instanceof Integer) {
            Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)this.mContext.getString(((Integer)resContent).intValue()));
            msg.what = 0;
            msg.sendToTarget();
        } else {
            Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)resContent);
            msg.what = 0;
            msg.sendToTarget();
        }
    }

    public void showToast(int res, int dur) {
        Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)this.mContext.getString(res));
        msg.arg1 = dur;
        msg.what = 0;
        msg.sendToTarget();
    }

    public void showToast(String str, int dur) {
        Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)str);
        msg.arg1 = dur;
        msg.what = 0;
        msg.sendToTarget();
    }

    public void showToast(int formatRes, Object[] params) {
        Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)MessageFormat.format(this.mContext.getString(formatRes), params));
        msg.what = 0;
        msg.sendToTarget();
    }

    public void showCustomToast(Object toastMessage) {
        Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)toastMessage);
        msg.what = 1;
        msg.sendToTarget();
    }

    private void customToastShow(Object res) {
        View layout2 = LayoutInflater.from((Context)this.mContext).inflate(R.layout.toast_custom_view, null);
        TextView text = (TextView)layout2.findViewById(R.id.text);
        if (res instanceof Integer) {
            text.setText(((Integer)res).intValue());
        } else {
            text.setText((CharSequence)res.toString());
        }
        Toast toast = new Toast(this.mContext);
        toast.setGravity(16, 0, 0);
        toast.setDuration(0);
        toast.setView(layout2);
        toast.show();
    }

    public void showWarnToast(int status, Object toastMessage) {
        Message msg = Message.obtain((Handler)this.mHandler, (int)0, (Object)toastMessage);
        msg.arg1 = status;
        msg.what = 2;
        msg.sendToTarget();
    }

    private void warnToastShow(int status, Object res) {
        View layout2 = LayoutInflater.from((Context)this.mContext).inflate(R.layout.toast_warn_view, null);
        TextView text = (TextView)layout2.findViewById(R.id.text);
        ImageView imageView = (ImageView)layout2.findViewById(R.id.image);
        if (res instanceof Integer) {
            text.setText(((Integer)res).intValue());
        } else {
            text.setText((CharSequence)res.toString());
        }
        if (status == 0) {
            imageView.setImageResource(R.mipmap.icon_warn);
        } else {
            imageView.setImageResource(R.mipmap.icon_ok);
        }
        Toast toast = new Toast(this.mContext);
        toast.setGravity(16, 0, 0);
        toast.setDuration(0);
        toast.setView(layout2);
        toast.show();
    }
}

