/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.pullrefresh;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.art.uilibrary.R;
import com.art.uilibrary.pullrefresh.FooterLoadingLayout;
import com.art.uilibrary.pullrefresh.HTML5WebView;
import com.art.uilibrary.pullrefresh.HeaderLoadingLayout;
import com.art.uilibrary.pullrefresh.ILoadingLayout;
import com.art.uilibrary.pullrefresh.IPullToRefresh;
import com.art.uilibrary.pullrefresh.LoadingLayout;
import com.art.uilibrary.utils.UiScreenUtils;

public abstract class PullToRefreshBase<T extends View>
extends LinearLayout
implements IPullToRefresh<T> {
    private final String TAG = this.getClass().getSimpleName();
    private static final int SCROLL_DURATION = 150;
    private static final float OFFSET_RADIO = 2.5f;
    T mRefreshableView;
    private float mLastMotionY = -1.0f;
    private float mLastMotionX = -1.0f;
    private OnRefreshListener<T> mRefreshListener;
    private LoadingLayout mHeaderLayout;
    private LoadingLayout mFooterLayout;
    private int mHeaderHeight;
    private int mFooterHeight;
    private boolean mPullRefreshEnabled = true;
    private boolean mPullLoadEnabled = false;
    private boolean mPullDeepEnabled = false;
    private boolean mScrollLoadEnabled = true;
    private boolean mInterceptEventEnable = true;
    private boolean mIsHandledTouchEvent = false;
    private int mTouchSlop;
    private ILoadingLayout.State mPullDownState = ILoadingLayout.State.NONE;
    private ILoadingLayout.State mPullUpState = ILoadingLayout.State.NONE;
    private SmoothScrollRunnable mSmoothScrollRunnable;
    private FrameLayout mRefreshableViewWrapper;
    private String headMode;
    private ScrollCallBack scrollCallBack;
    private ReleaseDeepCallBack releaseDeepCallBack;

    public PullToRefreshBase(Context context) {
        super(context);
        this.init(context, null);
    }

    public PullToRefreshBase(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public int getmHeaderHeight() {
        return this.mHeaderHeight;
    }

    public PullToRefreshBase(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setOrientation(1);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        TypedArray s = context.obtainStyledAttributes(attrs, R.styleable.PullToRefresh);
        this.headMode = s.getString(R.styleable.PullToRefresh_ptrHeadMode);
        this.mFooterLayout = this.createFooterLoadingLayout(context, attrs);
        this.mHeaderLayout = this.createHeaderLoadingLayout(context, attrs);
        this.mRefreshableView = this.createRefreshableView(context, attrs);
        if (this.mRefreshableView == null) {
            throw new NullPointerException("Refreshable view can not be null.");
        }
        this.addRefreshableView(context, this.mRefreshableView);
        this.addHeaderAndFooter(context);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                PullToRefreshBase.this.refreshLoadingViewsSize();
                PullToRefreshBase.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private void refreshLoadingViewsSize() {
        int footerHeight;
        int headerHeight = this.mHeaderLayout != null ? this.mHeaderLayout.getContentSize() : 0;
        int n = footerHeight = this.mFooterLayout != null ? this.mFooterLayout.getContentSize() : 0;
        if (headerHeight < 0) {
            headerHeight = 0;
        }
        if (footerHeight < 0) {
            footerHeight = 0;
        }
        this.mHeaderHeight = headerHeight;
        this.mFooterHeight = footerHeight;
        headerHeight = this.mHeaderLayout != null ? this.mHeaderLayout.getMeasuredHeight() : 0;
        int n2 = footerHeight = this.mFooterLayout != null ? this.mFooterLayout.getMeasuredHeight() : 0;
        if (footerHeight == 0) {
            footerHeight = this.mFooterHeight;
        }
        int pLeft = this.getPaddingLeft();
        int pTop = this.getPaddingTop();
        int pRight = this.getPaddingRight();
        int pBottom = this.getPaddingBottom();
        pTop = -headerHeight;
        pBottom = -footerHeight;
        this.setPadding(pLeft, pTop, pRight, pBottom);
    }

    protected final void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.refreshLoadingViewsSize();
        this.refreshRefreshableViewSize(w, h);
        this.post(new Runnable(){

            @Override
            public void run() {
                PullToRefreshBase.this.requestLayout();
            }
        });
    }

    public void setOrientation(int orientation) {
        if (orientation != 1) {
            throw new IllegalArgumentException("This class only supports VERTICAL orientation.");
        }
        super.setOrientation(orientation);
    }

    public final boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.isInterceptTouchEventEnabled()) {
            return false;
        }
        if (!this.isPullLoadEnabled() && !this.isPullRefreshEnabled()) {
            return false;
        }
        int action = event.getAction();
        if (action == 3 || action == 1) {
            this.mIsHandledTouchEvent = false;
            return false;
        }
        if (action != 0 && this.mIsHandledTouchEvent) {
            return true;
        }
        switch (action) {
            case 0: {
                this.mLastMotionY = event.getY();
                this.mLastMotionX = event.getX();
                this.mIsHandledTouchEvent = false;
                break;
            }
            case 2: {
                float deltaY = event.getY() - this.mLastMotionY;
                float absDiffY = Math.abs(deltaY);
                float deltaX = event.getX() - this.mLastMotionX;
                float absDiffX = Math.abs(deltaX);
                if (!(absDiffY > (float)this.mTouchSlop && absDiffY > absDiffX || this.isPullRefreshing()) && !this.isPullLoading()) break;
                this.mLastMotionY = event.getY();
                if (this.isPullRefreshEnabled() && this.isReadyForPullDown()) {
                    boolean bl = this.mIsHandledTouchEvent = Math.abs(this.getScrollYValue()) > 0 || deltaY > 0.5f;
                    if (!this.mIsHandledTouchEvent) break;
                    this.mRefreshableView.onTouchEvent(event);
                    break;
                }
                if (!this.isPullLoadEnabled() || !this.isReadyForPullUp()) break;
                this.mIsHandledTouchEvent = Math.abs(this.getScrollYValue()) > 0 || deltaY < -0.5f;
                break;
            }
        }
        Log.i((String)this.TAG, (String)("onInterceptTouchEvent" + this.mIsHandledTouchEvent));
        return this.mIsHandledTouchEvent;
    }

    public final boolean onTouchEvent(MotionEvent ev) {
        boolean handled = false;
        switch (ev.getAction()) {
            case 0: {
                this.mLastMotionY = ev.getY();
                this.mIsHandledTouchEvent = false;
                break;
            }
            case 2: {
                float deltaY = ev.getY() - this.mLastMotionY;
                this.mLastMotionY = ev.getY();
                if (this.isPullRefreshEnabled() && this.isReadyForPullDown()) {
                    this.pullHeaderLayout(deltaY / 2.5f);
                    handled = true;
                    break;
                }
                if (this.isPullLoadEnabled() && this.isReadyForPullUp()) {
                    this.pullFooterLayout(deltaY / 2.5f);
                    handled = true;
                    break;
                }
                this.mIsHandledTouchEvent = false;
                break;
            }
            case 1: 
            case 3: {
                if (!this.mIsHandledTouchEvent) break;
                this.mIsHandledTouchEvent = false;
                if (this.isReadyForPullDown()) {
                    if (this.mPullRefreshEnabled && (this.mPullDownState == ILoadingLayout.State.RELEASE_TO_REFRESH || this.mPullDownState == ILoadingLayout.State.RELEASE_TO_DEEP)) {
                        if (this.mPullDownState == ILoadingLayout.State.RELEASE_TO_DEEP && this.isPullDeepEnabled()) {
                            this.startDeep();
                            break;
                        }
                        this.startRefreshing();
                        break;
                    }
                    handled = true;
                    this.resetHeaderLayout();
                    break;
                }
                if (!this.isReadyForPullUp()) break;
                if (this.isPullLoadEnabled() && this.mPullUpState == ILoadingLayout.State.RELEASE_TO_REFRESH) {
                    this.startLoading();
                    handled = true;
                }
                this.resetFooterLayout();
                break;
            }
        }
        return handled;
    }

    @Override
    public boolean isPullRefreshEnabled() {
        return this.mPullRefreshEnabled && this.mHeaderLayout != null;
    }

    @Override
    public void setPullRefreshEnabled(boolean pullRefreshEnabled) {
        this.mPullRefreshEnabled = pullRefreshEnabled;
    }

    @Override
    public boolean isPullLoadEnabled() {
        return this.mPullLoadEnabled && this.mFooterLayout != null;
    }

    @Override
    public void setPullLoadEnabled(boolean pullLoadEnabled) {
        this.mPullLoadEnabled = pullLoadEnabled;
    }

    @Override
    public boolean isPullDeepEnabled() {
        return this.mPullDeepEnabled && this.mHeaderLayout != null;
    }

    @Override
    public void setPullDeepEnabled(boolean pullDeepEnabled) {
        this.mPullDeepEnabled = pullDeepEnabled;
    }

    @Override
    public boolean isScrollLoadEnabled() {
        return this.mScrollLoadEnabled;
    }

    @Override
    public void setScrollLoadEnabled(boolean scrollLoadEnabled) {
        this.mScrollLoadEnabled = scrollLoadEnabled;
    }

    @Override
    public void setOnRefreshListener(OnRefreshListener<T> refreshListener) {
        this.mRefreshListener = refreshListener;
    }

    @Override
    public void onPullDownRefreshComplete() {
        if (this.isPullRefreshing()) {
            this.mPullDownState = ILoadingLayout.State.RESET;
            this.onStateChanged(ILoadingLayout.State.RESET, true);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PullToRefreshBase.this.setInterceptTouchEventEnabled(true);
                    PullToRefreshBase.this.mHeaderLayout.setState(ILoadingLayout.State.RESET);
                }
            }, this.getSmoothScrollDuration());
            this.resetHeaderLayout();
            this.setInterceptTouchEventEnabled(false);
        }
    }

    @Override
    public void onPullUpRefreshComplete() {
        if (this.isPullLoading()) {
            this.mPullUpState = ILoadingLayout.State.RESET;
            this.onStateChanged(ILoadingLayout.State.RESET, false);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PullToRefreshBase.this.setInterceptTouchEventEnabled(true);
                    PullToRefreshBase.this.mFooterLayout.setState(ILoadingLayout.State.RESET);
                }
            }, this.getSmoothScrollDuration());
            this.resetFooterLayout();
            this.setInterceptTouchEventEnabled(false);
        }
    }

    @Override
    public T getRefreshableView() {
        return this.mRefreshableView;
    }

    @Override
    public LoadingLayout getHeaderLoadingLayout() {
        return this.mHeaderLayout;
    }

    @Override
    public LoadingLayout getFooterLoadingLayout() {
        return this.mFooterLayout;
    }

    @Override
    public void setLastUpdatedLabel(CharSequence label) {
        if (this.mHeaderLayout != null) {
            this.mHeaderLayout.setLastUpdatedLabel(label);
        }
        if (this.mFooterLayout != null) {
            this.mFooterLayout.setLastUpdatedLabel(label);
        }
    }

    public void doPullRefreshing(final boolean smoothScroll, long delayMillis) {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                int newScrollValue = -PullToRefreshBase.this.mHeaderHeight;
                int duration = smoothScroll ? 150 : 0;
                PullToRefreshBase.this.startRefreshing();
                PullToRefreshBase.this.smoothScrollTo(newScrollValue, duration, 0L);
            }
        }, delayMillis);
    }

    protected abstract T createRefreshableView(Context var1, AttributeSet var2);

    protected abstract boolean isReadyForPullDown();

    protected abstract boolean isReadyForPullUp();

    LoadingLayout createHeaderLoadingLayout(Context context, AttributeSet attrs) {
        return new HeaderLoadingLayout(context);
    }

    private LoadingLayout createFooterLoadingLayout(Context context, AttributeSet attrs) {
        return new FooterLoadingLayout(context);
    }

    private long getSmoothScrollDuration() {
        return 150L;
    }

    private void refreshRefreshableViewSize(int width, int height) {
        if (this.mRefreshableViewWrapper != null) {
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mRefreshableViewWrapper.getLayoutParams();
            if (lp.height != height) {
                lp.height = height;
                this.mRefreshableViewWrapper.requestLayout();
            }
        }
    }

    private void addRefreshableView(Context context, T refreshableView) {
        int width = -1;
        int height = -1;
        if (refreshableView instanceof HTML5WebView) {
            this.mRefreshableViewWrapper = ((HTML5WebView)((Object)refreshableView)).getLayout();
        } else {
            this.mRefreshableViewWrapper = new FrameLayout(context);
            this.mRefreshableViewWrapper.addView(refreshableView, width, height);
        }
        height = 10;
        this.addView((View)this.mRefreshableViewWrapper, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height));
    }

    private void addHeaderAndFooter(Context context) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        LoadingLayout headerLayout = this.mHeaderLayout;
        LoadingLayout footerLayout = this.mFooterLayout;
        if (headerLayout != null) {
            if (this == headerLayout.getParent()) {
                this.removeView((View)headerLayout);
            }
            this.addView((View)headerLayout, 0, (ViewGroup.LayoutParams)params);
        }
        if (footerLayout != null) {
            if (this == footerLayout.getParent()) {
                this.removeView((View)footerLayout);
            }
            this.addView((View)footerLayout, (ViewGroup.LayoutParams)params);
        }
    }

    public void setScrollCallBack(ScrollCallBack scrollCallBack) {
        this.scrollCallBack = scrollCallBack;
    }

    private void pullHeaderLayout(float delta) {
        int oldScrollY = this.getScrollYValue();
        if (delta < 0.0f && (float)oldScrollY - delta >= 0.0f) {
            this.setScrollTo(0, 0);
            return;
        }
        this.setScrollBy(0, -((int)delta));
        if (this.scrollCallBack != null) {
            this.scrollCallBack.scrollBy((int)delta);
        }
        if (this.mHeaderLayout != null && this.mHeaderHeight != 0) {
            float scale = (float)Math.abs(this.getScrollYValue()) / (float)this.mHeaderHeight;
            this.mHeaderLayout.onPull(scale);
        }
        int scrollY = Math.abs(this.getScrollYValue());
        if (this.isPullRefreshEnabled() && !this.isPullRefreshing()) {
            this.mPullDownState = this.isPullDeepEnabled() ? (scrollY <= this.mHeaderHeight - 100 ? ILoadingLayout.State.PULL_TO_REFRESH : (scrollY > this.mHeaderHeight - 100 && scrollY < this.mHeaderHeight ? ILoadingLayout.State.RELEASE_TO_REFRESH : ILoadingLayout.State.RELEASE_TO_DEEP)) : (scrollY > this.mHeaderHeight ? ILoadingLayout.State.RELEASE_TO_REFRESH : ILoadingLayout.State.PULL_TO_REFRESH);
            this.mHeaderLayout.setState(this.mPullDownState);
            this.onStateChanged(this.mPullDownState, true);
        }
    }

    private void pullFooterLayout(float delta) {
        int oldScrollY = this.getScrollYValue();
        if (delta > 0.0f && (float)oldScrollY - delta <= 0.0f) {
            this.setScrollTo(0, 0);
            return;
        }
        this.setScrollBy(0, -((int)delta));
        if (this.mFooterLayout != null && this.mFooterHeight != 0) {
            float scale = (float)Math.abs(this.getScrollYValue()) / (float)this.mFooterHeight;
            this.mFooterLayout.onPull(scale);
        }
        int scrollY = Math.abs(this.getScrollYValue());
        if (this.isPullLoadEnabled() && !this.isPullLoading()) {
            this.mPullUpState = scrollY > this.mFooterHeight ? ILoadingLayout.State.RELEASE_TO_REFRESH : ILoadingLayout.State.PULL_TO_REFRESH;
            this.mFooterLayout.setState(this.mPullUpState);
            this.onStateChanged(this.mPullUpState, false);
        }
    }

    private void resetHeaderLayout() {
        int scrollY = Math.abs(this.getScrollYValue());
        boolean refreshing = this.isPullRefreshing();
        if (refreshing && scrollY <= this.mHeaderHeight) {
            if (this.scrollCallBack != null) {
                this.scrollCallBack.scrollReset();
            }
            this.smoothScrollTo(0);
            return;
        }
        if (refreshing) {
            this.smoothScrollTo(-this.mHeaderHeight);
        } else {
            if (this.scrollCallBack != null) {
                this.scrollCallBack.scrollReset();
            }
            this.smoothScrollTo(0);
        }
    }

    public void setReleaseDeepCallBack(ReleaseDeepCallBack releaseDeepCallBack) {
        this.releaseDeepCallBack = releaseDeepCallBack;
    }

    private void setDeepHeaderLayout() {
        this.smoothScrollTo(UiScreenUtils.getScreenH(this.getContext()));
    }

    private void resetFooterLayout() {
        int scrollY = Math.abs(this.getScrollYValue());
        boolean isPullLoading = this.isPullLoading();
        if (isPullLoading && scrollY <= this.mFooterHeight) {
            this.smoothScrollTo(0);
            return;
        }
        if (isPullLoading) {
            this.smoothScrollTo(this.mFooterHeight);
        } else {
            this.smoothScrollTo(0);
        }
    }

    private boolean isPullRefreshing() {
        return this.mPullDownState == ILoadingLayout.State.REFRESHING || this.mPullDownState == ILoadingLayout.State.REFRESHING_DEEP;
    }

    private boolean isPullLoading() {
        return this.mPullUpState == ILoadingLayout.State.REFRESHING;
    }

    private void startDeep() {
        this.mPullDownState = ILoadingLayout.State.REFRESHING_DEEP;
        this.onStateChanged(ILoadingLayout.State.REFRESHING_DEEP, true);
        if (this.mHeaderLayout != null) {
            this.mHeaderLayout.setState(ILoadingLayout.State.REFRESHING_DEEP);
        }
        if (this.mRefreshListener != null) {
            int animTime = 1000;
            ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.getScrollY(), -UiScreenUtils.getScreenH(this.getContext()) - 200});
            animator.setDuration((long)animTime).start();
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int y = (Integer)animation.getAnimatedValue();
                    PullToRefreshBase.this.setScrollTo(0, y);
                    if (PullToRefreshBase.this.scrollCallBack != null) {
                        PullToRefreshBase.this.scrollCallBack.scrollTo(y);
                    }
                }
            });
            if (this.releaseDeepCallBack != null) {
                this.releaseDeepCallBack.result();
            }
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PullToRefreshBase.this.mRefreshListener.onPullDownToDeep(PullToRefreshBase.this);
                }
            }, animTime + 10);
        }
    }

    private void startRefreshing() {
        if (this.isPullRefreshing()) {
            return;
        }
        this.mPullDownState = ILoadingLayout.State.REFRESHING;
        this.onStateChanged(ILoadingLayout.State.REFRESHING, true);
        if (this.mHeaderLayout != null) {
            this.mHeaderLayout.setState(ILoadingLayout.State.REFRESHING);
        }
        if (this.mRefreshListener != null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PullToRefreshBase.this.mRefreshListener.onPullDownToRefresh(PullToRefreshBase.this);
                }
            }, this.getSmoothScrollDuration());
        }
    }

    void startLoading() {
        if (this.isPullLoading()) {
            return;
        }
        this.mPullUpState = ILoadingLayout.State.REFRESHING;
        this.onStateChanged(ILoadingLayout.State.REFRESHING, false);
        if (this.mFooterLayout != null) {
            this.mFooterLayout.setState(ILoadingLayout.State.REFRESHING);
        }
        if (this.mRefreshListener != null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PullToRefreshBase.this.mRefreshListener.onPullUpToRefresh(PullToRefreshBase.this);
                }
            }, this.getSmoothScrollDuration());
        }
    }

    private void onStateChanged(ILoadingLayout.State state, boolean isPullDown) {
    }

    private void setScrollTo(int x, int y) {
        this.scrollTo(x, y);
    }

    private void setScrollBy(int x, int y) {
        this.scrollBy(x, y);
    }

    private int getScrollYValue() {
        return this.getScrollY();
    }

    private void smoothScrollTo(int newScrollValue) {
        this.smoothScrollTo(newScrollValue, this.getSmoothScrollDuration(), 0L);
    }

    private void smoothScrollTo(int newScrollValue, long duration, long delayMillis) {
        int oldScrollValue;
        boolean post;
        if (this.mSmoothScrollRunnable != null) {
            this.mSmoothScrollRunnable.stop();
        }
        boolean bl = post = (oldScrollValue = this.getScrollYValue()) != newScrollValue;
        if (post) {
            this.mSmoothScrollRunnable = new SmoothScrollRunnable(oldScrollValue, newScrollValue, duration);
        }
        if (post) {
            if (delayMillis > 0L) {
                this.postDelayed(this.mSmoothScrollRunnable, delayMillis);
            } else {
                this.post(this.mSmoothScrollRunnable);
            }
        }
    }

    private boolean isInterceptTouchEventEnabled() {
        return this.mInterceptEventEnable;
    }

    private void setInterceptTouchEventEnabled(boolean enabled) {
        this.mInterceptEventEnable = enabled;
    }

    public ILoadingLayout.State getPullUpState() {
        return this.mPullUpState;
    }

    public ILoadingLayout.State getPullDownState() {
        return this.mPullDownState;
    }

    final class SmoothScrollRunnable
    implements Runnable {
        private final Interpolator mInterpolator;
        private final int mScrollToY;
        private final int mScrollFromY;
        private final long mDuration;
        private boolean mContinueRunning = true;
        private long mStartTime = -1L;
        private int mCurrentY = -1;

        public SmoothScrollRunnable(int fromY, int toY, long duration) {
            this.mScrollFromY = fromY;
            this.mScrollToY = toY;
            this.mDuration = duration;
            this.mInterpolator = new DecelerateInterpolator();
        }

        @Override
        public void run() {
            if (this.mDuration <= 0L) {
                PullToRefreshBase.this.setScrollTo(0, this.mScrollToY);
                return;
            }
            if (this.mStartTime == -1L) {
                this.mStartTime = System.currentTimeMillis();
            } else {
                long oneSecond = 1000L;
                long normalizedTime = 1000L * (System.currentTimeMillis() - this.mStartTime) / this.mDuration;
                normalizedTime = Math.max(Math.min(normalizedTime, 1000L), 0L);
                int deltaY = Math.round((float)(this.mScrollFromY - this.mScrollToY) * this.mInterpolator.getInterpolation((float)normalizedTime / 1000.0f));
                this.mCurrentY = this.mScrollFromY - deltaY;
                PullToRefreshBase.this.setScrollTo(0, this.mCurrentY);
            }
            if (this.mContinueRunning && this.mScrollToY != this.mCurrentY) {
                PullToRefreshBase.this.postDelayed(this, 16L);
            }
        }

        public void stop() {
            this.mContinueRunning = false;
            PullToRefreshBase.this.removeCallbacks(this);
        }
    }

    public static interface OnRefreshListener<V extends View> {
        public void onPullDownToDeep(PullToRefreshBase<V> var1);

        public void onPullDownToRefresh(PullToRefreshBase<V> var1);

        public void onPullUpToRefresh(PullToRefreshBase<V> var1);
    }

    public static interface ReleaseDeepCallBack {
        public void result();
    }

    public static interface ScrollCallBack {
        public void scrollTo(int var1);

        public void scrollBy(int var1);

        public void scrollReset();
    }
}

