/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.wheel.adapter;

import android.content.Context;
import com.art.uilibrary.wheel.adapter.AbstractWheelTextAdapter;

public class NumericWheelAdapter
extends AbstractWheelTextAdapter {
    private static final int DEFAULT_MAX_VALUE = 9;
    private static final int DEFAULT_MIN_VALUE = 0;
    private final int minValue;
    private final int maxValue;
    private int interval = 1;
    private final String format;

    public NumericWheelAdapter(Context context) {
        this(context, 0, 9);
    }

    private NumericWheelAdapter(Context context, int minValue, int maxValue) {
        this(context, minValue, maxValue, null);
    }

    public NumericWheelAdapter(Context context, int minValue, int maxValue, String format) {
        super(context);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.format = format;
    }

    public NumericWheelAdapter(Context context, int minValue, int maxValue, String format, int interval) {
        super(context);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.format = format;
        this.interval = interval;
    }

    public NumericWheelAdapter(Context context, Object ... objects) {
        super(context);
        this.minValue = (Integer)objects[0];
        this.maxValue = (Integer)objects[1];
        this.format = (String)objects[2];
        if (objects.length > 4) {
            this.interval = (Integer)objects[4];
        }
    }

    @Override
    public CharSequence getItemText(int index) {
        if (index >= 0 && index < this.getItemsCount()) {
            int value = (this.minValue + index) * this.interval;
            return this.format != null ? String.format(this.format, value) : Integer.toString(value);
        }
        return null;
    }

    @Override
    public int getItemsCount() {
        return this.maxValue - this.minValue + 1;
    }
}

