/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.pullrefresh;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.art.uilibrary.R;
import com.art.uilibrary.pullrefresh.ILoadingLayout;
import com.art.uilibrary.pullrefresh.LoadingLayout;

public class HeaderLoadingLayout
extends LoadingLayout {
    private static final int ROTATE_ANIM_DURATION = 150;
    private LinearLayout mHeaderContainer;
    private ImageView mArrowImageView;
    private ProgressBar mProgressBar;
    private TextView mHintTextView;
    private TextView mHeaderTimeView;
    private TextView mHeaderTimeViewTitle;
    private Animation mRotateUpAnim;
    private Animation mRotateDownAnim;
    private AnimationDrawable mTopAnim;
    private ImageView mTopAnimImg;
    private Context mContext;

    public HeaderLoadingLayout(Context context) {
        super(context);
        this.mContext = context;
        this.init(context);
    }

    public HeaderLoadingLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mHeaderContainer = (LinearLayout)this.findViewById(R.id.pull_to_refresh_header_content);
        this.mArrowImageView = (ImageView)this.findViewById(R.id.pull_to_refresh_header_arrow);
        this.mHintTextView = (TextView)this.findViewById(R.id.pull_to_refresh_header_hint_textview);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.pull_to_refresh_header_progressbar);
        this.mHeaderTimeView = (TextView)this.findViewById(R.id.pull_to_refresh_header_time);
        this.mHeaderTimeViewTitle = (TextView)this.findViewById(R.id.pull_to_refresh_last_update_time_text);
        this.mTopAnimImg = (ImageView)this.findViewById(R.id.top_anim);
        this.mTopAnim = (AnimationDrawable)this.mTopAnimImg.getDrawable();
        float pivotValue = 0.5f;
        float toDegree = -180.0f;
        this.mRotateUpAnim = new RotateAnimation(0.0f, toDegree, 1, pivotValue, 1, pivotValue);
        this.mRotateUpAnim.setDuration(150L);
        this.mRotateUpAnim.setFillAfter(true);
        this.mRotateDownAnim = new RotateAnimation(toDegree, 0.0f, 1, pivotValue, 1, pivotValue);
        this.mRotateDownAnim.setDuration(150L);
        this.mRotateDownAnim.setFillAfter(true);
    }

    @Override
    public void setLastUpdatedLabel(CharSequence label) {
        this.mHeaderTimeViewTitle.setVisibility(TextUtils.isEmpty((CharSequence)label) ? 4 : 0);
        this.mHeaderTimeView.setText(label);
    }

    @Override
    public int getContentSize() {
        if (this.mHeaderContainer != null) {
            return this.mHeaderContainer.getHeight();
        }
        return (int)(this.getResources().getDisplayMetrics().density * 60.0f);
    }

    @Override
    protected View createLoadingView(Context context, AttributeSet attrs) {
        return LayoutInflater.from((Context)context).inflate(R.layout.ptr_pull_to_refresh_header, null);
    }

    @Override
    protected void onStateChanged(ILoadingLayout.State curState, ILoadingLayout.State oldState) {
        this.mArrowImageView.setVisibility(0);
        this.mProgressBar.setVisibility(4);
        super.onStateChanged(curState, oldState);
    }

    @Override
    protected void onReset() {
        this.mArrowImageView.clearAnimation();
        this.mTopAnim.stop();
        this.mHintTextView.setText(R.string.pull_to_refresh_header_hint_normal);
    }

    @Override
    protected void onPullToRefresh() {
        if (this.getPreState() == ILoadingLayout.State.RELEASE_TO_REFRESH) {
            this.mArrowImageView.clearAnimation();
            this.mArrowImageView.startAnimation(this.mRotateDownAnim);
        }
        this.mHintTextView.setText(R.string.pull_to_refresh_header_hint_normal);
    }

    @Override
    protected void onReleaseToRefresh() {
        this.mArrowImageView.clearAnimation();
        this.mArrowImageView.startAnimation(this.mRotateUpAnim);
        this.mHintTextView.setText(R.string.pull_to_refresh_header_hint_ready);
    }

    @Override
    public void onRefreshing() {
        this.mArrowImageView.clearAnimation();
        this.mArrowImageView.setVisibility(4);
        this.mProgressBar.setVisibility(0);
        this.mTopAnim.start();
        this.mHintTextView.setText(R.string.pull_to_refresh_header_hint_loading);
    }
}

