/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.content.Context;
import android.text.InputFilter;
import android.text.Spanned;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.EditText;
import java.lang.reflect.Field;

public class SuperEditTexit
extends EditText {
    public SuperEditTexit(Context context) {
        super(context);
    }

    public SuperEditTexit(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setFilters(InputFilter[] filters) {
        if (filters == null) {
            return;
        }
        int len = filters.length;
        if (len <= 0) {
            return;
        }
        for (int i = len - 1; i >= 0; --i) {
            InputFilter filter = filters[i];
            if (!(filter instanceof InputFilter.LengthFilter)) continue;
            filters[i] = new SMLengthFilter(this.getMaxLength((InputFilter.LengthFilter)filter));
            break;
        }
        super.setFilters(filters);
    }

    private int getMaxLength(InputFilter.LengthFilter filter) {
        int max = 0;
        Class<?> clazz = filter.getClass();
        try {
            Field field = clazz.getDeclaredField("mMax");
            field.setAccessible(true);
            max = field.getInt(filter);
            Log.d((String)"getMaxLength", (String)("max=" + max));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return max;
    }

    public static class SMLengthFilter
    extends InputFilter.LengthFilter {
        int selfMax = 0;

        public SMLengthFilter(int max) {
            super(max);
            this.selfMax = max;
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            int destLen = dend = this.getSequenceLength((CharSequence)dest);
            int sourceLen = this.getSequenceLength(source);
            int keep = this.selfMax - destLen;
            if (keep <= 0) {
                return "";
            }
            if (keep >= sourceLen) {
                return null;
            }
            return this.subSequence(source, keep);
        }

        private CharSequence subSequence(CharSequence source, int keep) {
            if (source == null || source.length() <= 0) {
                return "";
            }
            int length = 0;
            for (int i = 0; i < source.length(); ++i) {
                char c = source.charAt(i);
                length = this.isChinese(c) ? (length += 2) : ++length;
                if (length <= keep) continue;
                if (i == 0) {
                    return "";
                }
                return source.subSequence(0, i);
            }
            return source;
        }

        private int getSequenceLength(CharSequence cs) {
            int length = 0;
            if (cs == null || cs.length() == 0) {
                return length;
            }
            for (int i = 0; i < cs.length(); ++i) {
                char c = cs.charAt(i);
                if (this.isChinese(c)) {
                    length += 2;
                    continue;
                }
                ++length;
            }
            return length;
        }

        private boolean isChinese(char c) {
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
            return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
        }
    }
}

