/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.nui.multiphotopicker.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.widget.ImageView;
import com.art.uilibrary.R;
import com.art.uilibrary.utils.UiImageUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;

public class ImageDisplayer {
    private static final int THUMB_WIDTH = 256;
    private static final int THUMB_HEIGHT = 256;
    private static ImageDisplayer instance;
    private final String TAG = this.getClass().getSimpleName();
    private final Handler h = new Handler();
    private final int mScreenWidth;
    private final int mScreenHeight;
    private final HashMap<String, SoftReference<Bitmap>> imageCache = new HashMap();

    private ImageDisplayer(Context context) {
        Context context1 = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        DisplayMetrics dm = new DisplayMetrics();
        dm = context1.getResources().getDisplayMetrics();
        this.mScreenWidth = dm.widthPixels;
        this.mScreenHeight = dm.heightPixels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageDisplayer getInstance(Context context) {
        if (instance != null) return instance;
        Class<ImageDisplayer> clazz = ImageDisplayer.class;
        synchronized (ImageDisplayer.class) {
            instance = new ImageDisplayer(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void put(String key, Bitmap bmp) {
        if (!TextUtils.isEmpty((CharSequence)key) && bmp != null) {
            this.imageCache.put(key, new SoftReference<Bitmap>(bmp));
        }
    }

    public void displayBmp(ImageView iv, String thumbPath, String sourcePath) {
        this.displayBmp(iv, thumbPath, sourcePath, true, 0, 0);
    }

    public void displayBmp(ImageView iv, String thumbPath, String sourcePath, boolean showThumb) {
        this.displayBmp(iv, thumbPath, sourcePath, showThumb, 0, 0);
    }

    public void displayBmp(final ImageView iv, final String thumbPath, final String sourcePath, final boolean showThumb, final int width, final int height) {
        SoftReference<Bitmap> reference;
        Bitmap imgInCache;
        String path;
        if (TextUtils.isEmpty((CharSequence)thumbPath) && TextUtils.isEmpty((CharSequence)sourcePath)) {
            Log.e((String)this.TAG, (String)"no paths pass in");
            return;
        }
        if (iv.getTag() != null && iv.getTag().equals(sourcePath)) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)thumbPath) && showThumb) {
            path = thumbPath;
        } else if (!TextUtils.isEmpty((CharSequence)sourcePath)) {
            path = sourcePath;
        } else {
            return;
        }
        iv.setTag((Object)path);
        if (this.imageCache.containsKey(showThumb ? path + 256 + 256 : path) && (imgInCache = (reference = this.imageCache.get(showThumb ? path + 256 + 256 : path)).get()) != null) {
            this.refreshView(iv, imgInCache, path);
            return;
        }
        iv.setImageBitmap(null);
        new Thread(){
            Bitmap img;

            @Override
            public void run() {
                try {
                    if (path != null && path.equals(thumbPath)) {
                        this.img = BitmapFactory.decodeFile((String)path);
                    }
                    if (this.img == null) {
                        this.img = ImageDisplayer.this.compressImg(sourcePath, showThumb);
                    }
                    if (this.img != null) {
                        if (width != 0 && height != 0) {
                            this.img = UiImageUtils.getResize(this.img, width, height);
                        }
                        ImageDisplayer.this.put(showThumb ? path + 256 + 256 : path, this.img);
                    }
                }
                catch (Exception exception) {
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
                ImageDisplayer.this.h.post(new Runnable(){

                    @Override
                    public void run() {
                        ImageDisplayer.this.refreshView(iv, img, path);
                    }
                });
            }
        }.start();
    }

    private void refreshView(ImageView imageView, Bitmap bitmap, String path) {
        if (imageView != null && bitmap != null && path != null) {
            imageView.setImageBitmap(bitmap);
            imageView.setTag((Object)path);
        }
    }

    private void showDefault(ImageView iv) {
        iv.setBackgroundResource(R.mipmap.nui_photo_default);
    }

    private Bitmap compressImg(String path, boolean showThumb) throws IOException {
        Bitmap bitmap;
        block5: {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(path)));
            BitmapFactory.Options opt = new BitmapFactory.Options();
            opt.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)opt);
            in.close();
            int i = 0;
            bitmap = null;
            if (showThumb) {
                while (true) {
                    if (opt.outWidth >> i <= 256 && opt.outHeight >> i <= 256) {
                        in = new BufferedInputStream(new FileInputStream(new File(path)));
                        opt.inSampleSize = (int)Math.pow(2.0, i);
                        opt.inJustDecodeBounds = false;
                        bitmap = BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)opt);
                        break block5;
                    }
                    ++i;
                }
            }
            while (true) {
                if (opt.outWidth >> i <= this.mScreenWidth && opt.outHeight >> i <= this.mScreenHeight) {
                    in = new BufferedInputStream(new FileInputStream(new File(path)));
                    opt.inSampleSize = (int)Math.pow(2.0, i);
                    opt.inJustDecodeBounds = false;
                    bitmap = BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)opt);
                    break;
                }
                ++i;
            }
        }
        return bitmap;
    }

    public static interface ImageCallback {
        public void imageLoad(ImageView var1, Bitmap var2, Object ... var3);
    }
}

