/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.nui.multiphotopicker.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.art.uilibrary.R;
import com.art.uilibrary.base.IAdapterListener;
import com.art.uilibrary.nui.multiphotopicker.model.ImageItem;
import com.art.uilibrary.utils.UiScreenUtils;
import com.art.uilibrary.utils.UiUtils;
import com.art.uilibrary.xrecyclerview.adapter.RecycleViewAdapter;
import com.art.uilibrary.xrecyclerview.adapter.RecycleViewHolder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import java.util.ArrayList;
import java.util.List;

public class ImageAllAdapter
extends RecycleViewAdapter<ImageItem>
implements IAdapterListener.IOnChildClickListener<Integer> {
    private List<ImageItem> mSelectList = new ArrayList<ImageItem>();
    private int mCanAddCount;
    private boolean mMultiChoice = true;
    private int mImgWidth;
    private int mImgHeight;
    private int mMaxImgCounts;
    private int mDisplayType;
    IImageCheckListener mCheckListener;

    public void setCanAddCount(int canAddCount) {
        this.mCanAddCount = canAddCount;
    }

    public void setMultiChoice(boolean multiChoice) {
        this.mMultiChoice = multiChoice;
    }

    public void setSelectList(List<ImageItem> selectList) {
        this.mSelectList = selectList;
    }

    public ImageAllAdapter(Context context, int layoutResID, int maxImgCounts, int displayType) {
        super(context, layoutResID);
        this.mDisplayType = displayType;
        this.mMaxImgCounts = maxImgCounts;
        this.setOnChildClickListener(this);
        if (this.mDisplayType == 0) {
            this.setHeadLayoutResID(R.layout.up_item_camera);
        }
        this.mImgHeight = this.mImgWidth = UiScreenUtils.dp2Px(this.mContext, 93.0f);
    }

    @Override
    protected void convert(final RecycleViewHolder holder, ImageItem item, int position) {
        TextView numView = (TextView)holder.getElement(R.id.num);
        ImageView ivGif = (ImageView)holder.getElement(R.id.iv_gif);
        numView.setText((CharSequence)(item.mSelectIndex != 0 ? String.valueOf(item.mSelectIndex) : ""));
        ImageView imageView = (ImageView)holder.getElement(R.id.img);
        RequestOptions options = (RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).override(this.mImgWidth, this.mImgHeight);
        Glide.with((Context)this.mContext).asBitmap().load("file://" + item.sourcePath).apply((BaseRequestOptions)options).into(imageView);
        holder.getElement(R.id.layout).setSelected(item.isSelected);
        if (!TextUtils.isEmpty((CharSequence)item.sourcePath) && item.sourcePath.contains(".gif")) {
            ivGif.setVisibility(0);
        } else {
            ivGif.setVisibility(4);
        }
        if (this.mCanAddCount <= 0) {
            holder.getElement(R.id.shadow_view).setVisibility(item.isSelected ? 8 : 0);
        } else {
            holder.getElement(R.id.shadow_view).setVisibility(8);
        }
        if (!this.mMultiChoice) {
            numView.setVisibility(8);
        }
        if (this.mDisplayType == 0) {
            holder.getElement(R.id.num_layout).setVisibility(0);
        }
        holder.getElement(R.id.num_layout).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int position = holder.getLayoutPosition();
                ImageItem imageItem = (ImageItem)ImageAllAdapter.this.list.get(--position);
                if (imageItem.isSelected) {
                    ImageAllAdapter.this.mCanAddCount++;
                    ImageAllAdapter.this.mSelectList.remove(imageItem);
                    ImageAllAdapter.this.list.remove(imageItem);
                    imageItem.isSelected = false;
                    int targetIndex = imageItem.mSelectIndex;
                    imageItem.mSelectIndex = 0;
                    ImageAllAdapter.this.list.add(position, imageItem);
                    if (ImageAllAdapter.this.mCanAddCount != 1) {
                        ImageAllAdapter.this.notifyItemChanged(position + 1);
                    }
                    int size = ImageAllAdapter.this.mSelectList.size();
                    for (int i = 0; i < size; ++i) {
                        ImageItem ii = (ImageItem)ImageAllAdapter.this.mSelectList.get(i);
                        if (ii.mSelectIndex <= targetIndex) continue;
                        ImageAllAdapter.this.list.remove(ii);
                        --ii.mSelectIndex;
                        ImageAllAdapter.this.list.add(ii.index, ii);
                        if (ImageAllAdapter.this.mCanAddCount == 1) continue;
                        ImageAllAdapter.this.notifyItemChanged(ii.index + 1);
                    }
                    if (ImageAllAdapter.this.mCanAddCount == 1) {
                        ImageAllAdapter.this.notifyDataSetChanged();
                    }
                } else {
                    if (ImageAllAdapter.this.isFullChosen()) {
                        String beyondRes = ImageAllAdapter.this.mContext.getResources().getString(R.string.str_photo_count_beyond, new Object[]{ImageAllAdapter.this.mMaxImgCounts});
                        UiUtils.showConfirmDialog(ImageAllAdapter.this.mContext, (Object)beyondRes, R.string.str_known, false, true);
                        return;
                    }
                    ImageAllAdapter.this.mCanAddCount--;
                    ImageAllAdapter.this.list.remove(imageItem);
                    ImageAllAdapter.this.mSelectList.remove(imageItem);
                    imageItem.isSelected = true;
                    imageItem.mSelectIndex = ImageAllAdapter.this.mSelectList.size() + 1;
                    ImageAllAdapter.this.mSelectList.add(imageItem);
                    ImageAllAdapter.this.list.add(position, imageItem);
                    if (ImageAllAdapter.this.isFullChosen()) {
                        ImageAllAdapter.this.notifyDataSetChanged();
                    } else {
                        ImageAllAdapter.this.notifyItemChanged(position + 1);
                    }
                }
                ImageAllAdapter.this.mCheckListener.onImageChecked(ImageAllAdapter.this.mSelectList);
            }
        });
    }

    @Override
    public void onChildClickListener(Integer target) {
        if (this.isFullChosen()) {
            this.showFullToast();
            return;
        }
        int position = target;
        if (this.mDisplayType == 0) {
            if (position == 0) {
                this.mCheckListener.takePhoto();
                return;
            }
            target = target - 1;
        }
        if (!this.mMultiChoice) {
            this.mCheckListener.onImageGot(((ImageItem)this.list.get((int)target.intValue())).sourcePath);
        } else {
            this.mCheckListener.startImageViewActivity(this.list, this.mSelectList, target, this.mCanAddCount);
        }
    }

    private boolean isFullChosen() {
        return this.mCanAddCount <= 0;
    }

    private void showFullToast() {
        String beyondRes = this.mContext.getResources().getString(R.string.str_photo_count_beyond, new Object[]{this.mMaxImgCounts});
        UiUtils.showConfirmDialog(this.mContext, (Object)beyondRes, R.string.str_known, false, true);
    }

    public void setCheckListener(IImageCheckListener checkListener) {
        this.mCheckListener = checkListener;
    }

    public static interface IImageCheckListener {
        public void takePhoto();

        public void onImageChecked(List<ImageItem> var1);

        public void startImageViewActivity(List<ImageItem> var1, List<ImageItem> var2, int var3, int var4);

        public void onImageGot(String var1);
    }
}

