/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.vuforia;

import com.qualcomm.vuforia.CylinderTarget;
import com.qualcomm.vuforia.CylinderTargetResult;
import com.qualcomm.vuforia.Frame;
import com.qualcomm.vuforia.ImageTarget;
import com.qualcomm.vuforia.ImageTargetResult;
import com.qualcomm.vuforia.Marker;
import com.qualcomm.vuforia.MarkerResult;
import com.qualcomm.vuforia.MultiTarget;
import com.qualcomm.vuforia.MultiTargetResult;
import com.qualcomm.vuforia.ObjectTarget;
import com.qualcomm.vuforia.ObjectTargetResult;
import com.qualcomm.vuforia.Prop;
import com.qualcomm.vuforia.PropResult;
import com.qualcomm.vuforia.Surface;
import com.qualcomm.vuforia.SurfaceResult;
import com.qualcomm.vuforia.Trackable;
import com.qualcomm.vuforia.TrackableResult;
import com.qualcomm.vuforia.VuforiaJNI;
import com.qualcomm.vuforia.Word;
import com.qualcomm.vuforia.WordResult;

public class State
implements Cloneable {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private Frame mFrame = null;
    private Object mFrameMutex = new Object();

    protected State(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(State obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                VuforiaJNI.delete_State(this.swigCPtr);
            }
            Object object = this.mFrameMutex;
            synchronized (object) {
                if (this.mFrame != null) {
                    this.mFrame.delete();
                    this.mFrame = null;
                }
            }
            this.swigCPtr = 0L;
        }
    }

    public State clone() {
        return new State(this);
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof State) {
            equal = ((State)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public State() {
        this(VuforiaJNI.new_State__SWIG_0(), true);
    }

    public State(State other) {
        this(VuforiaJNI.new_State__SWIG_1(State.getCPtr(other), other), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame getFrame() {
        Object object = this.mFrameMutex;
        synchronized (object) {
            if (this.mFrame == null) {
                this.mFrame = new Frame(VuforiaJNI.State_getFrame(this.swigCPtr, this), true);
            }
        }
        return this.mFrame;
    }

    public int getNumTrackables() {
        return VuforiaJNI.State_getNumTrackables(this.swigCPtr, this);
    }

    public Trackable getTrackable(int idx) {
        long cPtr = VuforiaJNI.State_getTrackable(this.swigCPtr, this, idx);
        if (cPtr == 0L) {
            return null;
        }
        Trackable tmp = new Trackable(cPtr, false);
        if (tmp.isOfType(ImageTarget.getClassType())) {
            return new ImageTarget(cPtr, false);
        }
        if (tmp.isOfType(CylinderTarget.getClassType())) {
            return new CylinderTarget(cPtr, false);
        }
        if (tmp.isOfType(MultiTarget.getClassType())) {
            return new MultiTarget(cPtr, false);
        }
        if (tmp.isOfType(ObjectTarget.getClassType())) {
            return new ObjectTarget(cPtr, false);
        }
        if (tmp.isOfType(Word.getClassType())) {
            return new Word(cPtr, false);
        }
        if (tmp.isOfType(Marker.getClassType())) {
            return new Marker(cPtr, false);
        }
        if (tmp.isOfType(Surface.getClassType())) {
            return new Surface(cPtr, false);
        }
        if (tmp.isOfType(Prop.getClassType())) {
            return new Prop(cPtr, false);
        }
        return null;
    }

    public int getNumTrackableResults() {
        return VuforiaJNI.State_getNumTrackableResults(this.swigCPtr, this);
    }

    public TrackableResult getTrackableResult(int idx) {
        long cPtr = VuforiaJNI.State_getTrackableResult(this.swigCPtr, this, idx);
        if (cPtr == 0L) {
            return null;
        }
        TrackableResult tmp = new TrackableResult(cPtr, false);
        if (tmp.isOfType(ImageTargetResult.getClassType())) {
            return new ImageTargetResult(cPtr, false);
        }
        if (tmp.isOfType(CylinderTargetResult.getClassType())) {
            return new CylinderTargetResult(cPtr, false);
        }
        if (tmp.isOfType(MultiTargetResult.getClassType())) {
            return new MultiTargetResult(cPtr, false);
        }
        if (tmp.isOfType(ObjectTargetResult.getClassType())) {
            return new ObjectTargetResult(cPtr, false);
        }
        if (tmp.isOfType(WordResult.getClassType())) {
            return new WordResult(cPtr, false);
        }
        if (tmp.isOfType(MarkerResult.getClassType())) {
            return new MarkerResult(cPtr, false);
        }
        if (tmp.isOfType(SurfaceResult.getClassType())) {
            return new SurfaceResult(cPtr, false);
        }
        if (tmp.isOfType(PropResult.getClassType())) {
            return new PropResult(cPtr, false);
        }
        return null;
    }
}

