/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.vuforia;

import com.qualcomm.vuforia.Matrix44F;
import com.qualcomm.vuforia.Vuforia;
import com.qualcomm.vuforia.VuforiaJNI;

public class EyewearCalibrationProfileManager {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected EyewearCalibrationProfileManager(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(EyewearCalibrationProfileManager obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                VuforiaJNI.delete_EyewearCalibrationProfileManager(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof EyewearCalibrationProfileManager) {
            equal = ((EyewearCalibrationProfileManager)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int getMaxCount() {
        return VuforiaJNI.EyewearCalibrationProfileManager_getMaxCount(this.swigCPtr, this);
    }

    public int getUsedCount() {
        return VuforiaJNI.EyewearCalibrationProfileManager_getUsedCount(this.swigCPtr, this);
    }

    public boolean isProfileUsed(int profileID) {
        return VuforiaJNI.EyewearCalibrationProfileManager_isProfileUsed(this.swigCPtr, this, profileID);
    }

    public int getActiveProfile() {
        return VuforiaJNI.EyewearCalibrationProfileManager_getActiveProfile(this.swigCPtr, this);
    }

    public boolean setActiveProfile(int profileID) {
        return VuforiaJNI.EyewearCalibrationProfileManager_setActiveProfile(this.swigCPtr, this, profileID);
    }

    public Matrix44F getProjectionMatrix(int profileID, int eyeID) {
        return new Matrix44F(VuforiaJNI.EyewearCalibrationProfileManager_getProjectionMatrix(this.swigCPtr, this, profileID, eyeID), true);
    }

    public boolean setProjectionMatrix(int profileID, int eyeID, Matrix44F projectionMatrix) {
        return VuforiaJNI.EyewearCalibrationProfileManager_setProjectionMatrix(this.swigCPtr, this, profileID, eyeID, Matrix44F.getCPtr(projectionMatrix), projectionMatrix);
    }

    public String getProfileName(int profileID) {
        short[] codes = VuforiaJNI.EyewearCalibrationProfileManager_getProfileName(this.swigCPtr, this, profileID);
        if (codes == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(codes.length);
        for (short code : codes) {
            result.appendCodePoint(code);
        }
        return result.toString();
    }

    public boolean setProfileName(int profileID, String name) {
        return VuforiaJNI.EyewearCalibrationProfileManager_setProfileName(this.swigCPtr, this, profileID, Vuforia.convertStringToShortArray(name));
    }

    public boolean clearProfile(int profileID) {
        return VuforiaJNI.EyewearCalibrationProfileManager_clearProfile(this.swigCPtr, this, profileID);
    }
}

