/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.vuforia;

import com.qualcomm.vuforia.CameraCalibration;
import com.qualcomm.vuforia.EyewearCalibrationProfileManager;
import com.qualcomm.vuforia.EyewearUserCalibrator;
import com.qualcomm.vuforia.Matrix44F;
import com.qualcomm.vuforia.Vuforia;
import com.qualcomm.vuforia.VuforiaJNI;

public class Eyewear {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    public static final int EYEWEAR_PROFILE_ACTIVE = -1;
    public static final int EYEWEAR_PROFILE_DEFAULT = 0;

    protected Eyewear(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Eyewear obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                VuforiaJNI.delete_Eyewear(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Eyewear) {
            equal = ((Eyewear)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public static Eyewear getInstance() {
        if (!Vuforia.wasInitializedJava()) {
            throw new RuntimeException("Use of the Java Vuforia APIs requires initalization via the com.qualcomm.vuforia.Vuforia class");
        }
        return new Eyewear(VuforiaJNI.Eyewear_getInstance(), false);
    }

    public boolean isDeviceDetected() {
        return VuforiaJNI.Eyewear_isDeviceDetected(this.swigCPtr, this);
    }

    public boolean setHeadsetPresent(String id) {
        return VuforiaJNI.Eyewear_setHeadsetPresent(this.swigCPtr, this, id);
    }

    public boolean setHeadsetNotPresent() {
        return VuforiaJNI.Eyewear_setHeadsetNotPresent(this.swigCPtr, this);
    }

    public boolean isSeeThru() {
        return VuforiaJNI.Eyewear_isSeeThru(this.swigCPtr, this);
    }

    public int getScreenOrientation() {
        return VuforiaJNI.Eyewear_getScreenOrientation(this.swigCPtr, this);
    }

    public boolean isStereoCapable() {
        return VuforiaJNI.Eyewear_isStereoCapable(this.swigCPtr, this);
    }

    public boolean isStereoEnabled() {
        return VuforiaJNI.Eyewear_isStereoEnabled(this.swigCPtr, this);
    }

    public boolean isStereoGLOnly() {
        return VuforiaJNI.Eyewear_isStereoGLOnly(this.swigCPtr, this);
    }

    public boolean setStereo(boolean enable) {
        return VuforiaJNI.Eyewear_setStereo(this.swigCPtr, this, enable);
    }

    public boolean isPredictiveTrackingEnabled() {
        return VuforiaJNI.Eyewear_isPredictiveTrackingEnabled(this.swigCPtr, this);
    }

    public boolean setPredictiveTracking(boolean enable) {
        return VuforiaJNI.Eyewear_setPredictiveTracking(this.swigCPtr, this, enable);
    }

    public EyewearCalibrationProfileManager getProfileManager() {
        return new EyewearCalibrationProfileManager(VuforiaJNI.Eyewear_getProfileManager(this.swigCPtr, this), false);
    }

    public void setProjectionClippingPlanes(CameraCalibration cameraCalibration, float nearPlane, float farPlane) {
        VuforiaJNI.Eyewear_setProjectionClippingPlanes(this.swigCPtr, this, CameraCalibration.getCPtr(cameraCalibration), cameraCalibration, nearPlane, farPlane);
    }

    public Matrix44F getProjectionMatrix(int eyeID, int profileID) {
        return new Matrix44F(VuforiaJNI.Eyewear_getProjectionMatrix__SWIG_0(this.swigCPtr, this, eyeID, profileID), true);
    }

    public Matrix44F getProjectionMatrix(int eyeID) {
        return new Matrix44F(VuforiaJNI.Eyewear_getProjectionMatrix__SWIG_1(this.swigCPtr, this, eyeID), true);
    }

    public Matrix44F getOrthographicProjectionMatrix() {
        return new Matrix44F(VuforiaJNI.Eyewear_getOrthographicProjectionMatrix(this.swigCPtr, this), true);
    }

    public EyewearUserCalibrator getCalibrator() {
        return new EyewearUserCalibrator(VuforiaJNI.Eyewear_getCalibrator(this.swigCPtr, this), false);
    }

    public static final class ORIENTATION {
        public static final int ORIENTATION_UNDEFINED = 0;
        public static final int ORIENTATION_PORTRAIT = 1;
        public static final int ORIENTATION_LANDSCAPE_LEFT = 2;
        public static final int ORIENTATION_LANDSCAPE_RIGHT = 3;
    }
}

