/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.QCARUnityPlayer;

import android.app.Activity;
import com.qualcomm.QCAR.QCAR;
import com.qualcomm.QCARUnityPlayer.DebugLog;

public class QCARInitializer {
    private static final String NATIVE_LIB_UNITYPLAYER = "QCARUnityPlayer";
    private static final String NATIVE_LIB_QCARWRAPPER = "QCARWrapper";
    private static final String NATIVE_LIB_QCAR = "Vuforia";

    private static native void initPlatformNative();

    public static void loadNativeLibraries() {
        QCARInitializer.loadLibrary(NATIVE_LIB_QCAR);
        QCARInitializer.loadLibrary(NATIVE_LIB_QCARWRAPPER);
        QCARInitializer.loadLibrary(NATIVE_LIB_UNITYPLAYER);
    }

    public static void initPlatform() {
        QCARInitializer.initPlatformNative();
    }

    public static int initQCAR(Activity activity, String licenseKey) {
        DebugLog.LOGD("Initializing Vuforia...");
        QCAR.setInitParameters((Activity)activity, (int)2, (String)licenseKey);
        int progressValue = -1;
        while ((progressValue = QCAR.init()) >= 0 && progressValue < 100) {
        }
        if (progressValue < 0) {
            DebugLog.LOGE("QCAR initialization failed");
            return progressValue;
        }
        return 0;
    }

    private static boolean loadLibrary(String nLibName) {
        try {
            System.loadLibrary(nLibName);
            return true;
        }
        catch (UnsatisfiedLinkError ulee) {
            DebugLog.LOGE("The library lib" + nLibName + ".so could not be loaded: " + ulee.toString());
        }
        catch (SecurityException se) {
            DebugLog.LOGE("The library lib" + nLibName + ".so was not allowed to be loaded");
        }
        return false;
    }
}

