/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.VuforiaMedia;

import android.app.Activity;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.os.Build;
import android.view.Surface;
import com.qualcomm.VuforiaMedia.DebugLog;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoPlayerHelper
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    public static final float CURRENT_POSITION = -1.0f;
    private MediaPlayer mMediaPlayer = null;
    private MEDIA_TYPE mVideoType = MEDIA_TYPE.UNKNOWN;
    private Object mSurfaceTexture = null;
    private int mCurrentBufferingPercentage = 0;
    private String mMovieName = "";
    private int mTextureID = 0;
    private Activity mParentActivity = null;
    private MEDIA_STATE mCurrentState = MEDIA_STATE.NOT_READY;
    private boolean mShouldPlayImmediately = false;
    private float mSeekPosition = -1.0f;
    private ReentrantLock mMediaPlayerLock = null;
    private ReentrantLock mSurfaceTextureLock = null;
    private int mMediaTextureID = -1;
    private int mDestTextureID = -1;
    private int mFBO = -1;
    private static Constructor<?> _surfaceTextureConstructor;
    private static Constructor<?> _surfaceConstructor;
    private static Method _updateTexImageFunc;
    private static Method _getTransformMatrixFunc;
    private static Method _releaseFunc;
    private final String CLASSNAME_SURFACETEXTURE = "android.graphics.SurfaceTexture";
    private final String CLASSNAME_SURFACE = "android.view.Surface";

    public native int initMediaTexture();

    public native void bindMediaTexture(int var1);

    public native int initFBO(int var1, int var2, int var3);

    public native void copyTexture(int var1, int var2, int var3, float[] var4, int var5, int var6);

    public static boolean loadLibrary(String nLibName) {
        try {
            System.loadLibrary(nLibName);
            DebugLog.LOGI("Native library lib" + nLibName + ".so loaded");
            return true;
        }
        catch (UnsatisfiedLinkError ulee) {
            DebugLog.LOGE("The library lib" + nLibName + ".so could not be loaded");
        }
        catch (SecurityException se) {
            DebugLog.LOGE("The library lib" + nLibName + ".so was not allowed to be loaded");
        }
        return false;
    }

    public boolean init() {
        this.mMediaPlayerLock = new ReentrantLock();
        this.mSurfaceTextureLock = new ReentrantLock();
        if (Build.VERSION.SDK_INT >= 14) {
            try {
                Class<?> surfaceTextureClass = Class.forName("android.graphics.SurfaceTexture");
                Class<?> surfaceClass = Class.forName("android.view.Surface");
                _surfaceTextureConstructor = surfaceTextureClass.getConstructor(Integer.TYPE);
                if (_surfaceTextureConstructor == null) {
                    DebugLog.LOGE("Couldn't find SurfaceTexture(int) constructor");
                    return false;
                }
                _surfaceConstructor = surfaceClass.getConstructor(surfaceTextureClass);
                if (_surfaceConstructor == null) {
                    DebugLog.LOGE("Couldn't find Surface(SurfaceTexture) constructor");
                    return false;
                }
                _updateTexImageFunc = VideoPlayerHelper.retrieveClassMethod(surfaceTextureClass, "updateTexImage", new Class[0]);
                if (_updateTexImageFunc == null) {
                    DebugLog.LOGE("Couldn't find SurfaceTexture.updateTexImage() method");
                    return false;
                }
                _getTransformMatrixFunc = VideoPlayerHelper.retrieveClassMethod(surfaceTextureClass, "getTransformMatrix", float[].class);
                if (_getTransformMatrixFunc == null) {
                    DebugLog.LOGE("Couldn't find SurfaceTexture.getTransformMatrix(float[]) method");
                    return false;
                }
                _releaseFunc = VideoPlayerHelper.retrieveClassMethod(surfaceTextureClass, "release", new Class[0]);
                if (_releaseFunc == null) {
                    DebugLog.LOGE("Couldn't find SurfaceTexture.release() method");
                    return false;
                }
            }
            catch (Exception e) {
                DebugLog.LOGE("Exception in init: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    public boolean deinit() {
        this.unload();
        this.mSurfaceTextureLock.lock();
        if (this.mSurfaceTexture != null) {
            try {
                _releaseFunc.invoke(this.mSurfaceTexture, new Object[0]);
            }
            catch (Exception e) {
                DebugLog.LOGE("Exception in deinit: " + e.getMessage());
            }
            this.mSurfaceTexture = null;
        }
        this.mSurfaceTextureLock.unlock();
        return true;
    }

    public boolean load(String filename, int type, boolean playOnTextureImmediately, float seekPosition) {
        MEDIA_TYPE requestedType = MEDIA_TYPE.values()[type];
        boolean canBeOnTexture = false;
        boolean canBeFullscreen = false;
        boolean result = false;
        this.mMediaPlayerLock.lock();
        this.mSurfaceTextureLock.lock();
        if (this.mCurrentState == MEDIA_STATE.READY || this.mMediaPlayer != null) {
            DebugLog.LOGD("Already loaded");
        } else {
            if ((requestedType == MEDIA_TYPE.ON_TEXTURE || requestedType == MEDIA_TYPE.ON_TEXTURE_FULLSCREEN) && Build.VERSION.SDK_INT >= 14) {
                this.mMediaTextureID = this.initMediaTexture();
                if (!this.setupSurfaceTexture(this.mMediaTextureID)) {
                    DebugLog.LOGD("Can't load file to ON_TEXTURE because the Surface Texture is not ready");
                } else {
                    AssetFileDescriptor afd = null;
                    try {
                        afd = this.mParentActivity.getAssets().openFd(filename);
                    }
                    catch (IOException e) {
                        afd = null;
                    }
                    try {
                        this.mMediaPlayer = new MediaPlayer();
                        if (afd != null) {
                            this.mMediaPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
                            afd.close();
                        } else {
                            this.mMediaPlayer.setDataSource(filename);
                        }
                        Object[] argList = new Object[]{this.mSurfaceTexture};
                        Surface surface = (Surface)_surfaceConstructor.newInstance(argList);
                        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
                        this.mMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
                        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
                        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
                        this.mMediaPlayer.setAudioStreamType(3);
                        this.mMediaPlayer.setSurface(surface);
                        canBeOnTexture = true;
                        this.mShouldPlayImmediately = playOnTextureImmediately;
                        this.mMediaPlayer.prepareAsync();
                    }
                    catch (Exception e) {
                        DebugLog.LOGD("Could not create a Media Player");
                        this.mCurrentState = MEDIA_STATE.ERROR;
                        this.mMediaPlayerLock.unlock();
                        this.mSurfaceTextureLock.unlock();
                        return false;
                    }
                }
            }
            if (requestedType == MEDIA_TYPE.FULLSCREEN || requestedType == MEDIA_TYPE.ON_TEXTURE_FULLSCREEN) {
                canBeFullscreen = true;
            }
            this.mMovieName = filename;
            this.mSeekPosition = seekPosition;
            if (canBeFullscreen && canBeOnTexture) {
                this.mVideoType = MEDIA_TYPE.ON_TEXTURE_FULLSCREEN;
            } else if (canBeFullscreen) {
                this.mVideoType = MEDIA_TYPE.FULLSCREEN;
                this.mCurrentState = MEDIA_STATE.READY;
            } else {
                this.mVideoType = canBeOnTexture ? MEDIA_TYPE.ON_TEXTURE : MEDIA_TYPE.UNKNOWN;
            }
            result = true;
        }
        this.mSurfaceTextureLock.unlock();
        this.mMediaPlayerLock.unlock();
        return result;
    }

    public boolean unload() {
        this.mMediaPlayerLock.lock();
        if (this.mMediaPlayer != null) {
            try {
                this.mMediaPlayer.stop();
            }
            catch (Exception e) {
                this.mMediaPlayerLock.unlock();
                DebugLog.LOGE("Could not start playback");
            }
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.mMediaPlayerLock.unlock();
        this.mCurrentState = MEDIA_STATE.NOT_READY;
        this.mVideoType = MEDIA_TYPE.UNKNOWN;
        return true;
    }

    public boolean isPlayableOnTexture() {
        return Build.VERSION.SDK_INT >= 14 && (this.mVideoType == MEDIA_TYPE.ON_TEXTURE || this.mVideoType == MEDIA_TYPE.ON_TEXTURE_FULLSCREEN);
    }

    public boolean isPlayableFullscreen() {
        return this.mVideoType == MEDIA_TYPE.FULLSCREEN || this.mVideoType == MEDIA_TYPE.ON_TEXTURE_FULLSCREEN;
    }

    int getStatus() {
        return this.mCurrentState.type;
    }

    public int getVideoWidth() {
        if (!this.isPlayableOnTexture()) {
            return -1;
        }
        if (this.mCurrentState == MEDIA_STATE.NOT_READY || this.mCurrentState == MEDIA_STATE.ERROR) {
            return -1;
        }
        int result = -1;
        this.mMediaPlayerLock.lock();
        if (this.mMediaPlayer != null) {
            result = this.mMediaPlayer.getVideoWidth();
        }
        this.mMediaPlayerLock.unlock();
        return result;
    }

    public int getVideoHeight() {
        if (!this.isPlayableOnTexture()) {
            return -1;
        }
        if (this.mCurrentState == MEDIA_STATE.NOT_READY || this.mCurrentState == MEDIA_STATE.ERROR) {
            return -1;
        }
        int result = -1;
        this.mMediaPlayerLock.lock();
        if (this.mMediaPlayer != null) {
            result = this.mMediaPlayer.getVideoHeight();
        }
        this.mMediaPlayerLock.unlock();
        return result;
    }

    public float getLength() {
        if (!this.isPlayableOnTexture()) {
            return -1.0f;
        }
        if (this.mCurrentState == MEDIA_STATE.NOT_READY || this.mCurrentState == MEDIA_STATE.ERROR) {
            return -1.0f;
        }
        int result = -1;
        this.mMediaPlayerLock.lock();
        if (this.mMediaPlayer != null) {
            result = this.mMediaPlayer.getDuration() / 1000;
        }
        this.mMediaPlayerLock.unlock();
        return result;
    }

    public boolean play(boolean fullScreen, float seekPosition) {
        if (fullScreen) {
            if (!this.isPlayableFullscreen()) {
                DebugLog.LOGD("Cannot play this video fullscreen, it was not requested on load");
                return false;
            }
            return true;
        }
        if (!this.isPlayableOnTexture()) {
            DebugLog.LOGD("Cannot play this video on texture, it was either not requested on load or is not supported on this plattform");
            return false;
        }
        if (this.mCurrentState == MEDIA_STATE.NOT_READY || this.mCurrentState == MEDIA_STATE.ERROR) {
            DebugLog.LOGD("Cannot play this video if it is not ready");
            return false;
        }
        this.mMediaPlayerLock.lock();
        if (seekPosition != -1.0f) {
            try {
                this.mMediaPlayer.seekTo((int)seekPosition * 1000);
            }
            catch (Exception e) {
                this.mMediaPlayerLock.unlock();
                DebugLog.LOGE("Could not seek to position");
            }
        } else if (this.mCurrentState == MEDIA_STATE.REACHED_END) {
            try {
                this.mMediaPlayer.seekTo(0);
            }
            catch (Exception e) {
                this.mMediaPlayerLock.unlock();
                DebugLog.LOGE("Could not seek to position");
            }
        }
        try {
            this.mMediaPlayer.start();
        }
        catch (Exception e) {
            this.mMediaPlayerLock.unlock();
            DebugLog.LOGE("Could not start playback");
        }
        this.mCurrentState = MEDIA_STATE.PLAYING;
        this.mMediaPlayerLock.unlock();
        return true;
    }

    public boolean pause() {
        if (!this.isPlayableOnTexture()) {
            return false;
        }
        if (this.mCurrentState == MEDIA_STATE.NOT_READY || this.mCurrentState == MEDIA_STATE.ERROR) {
            return false;
        }
        boolean result = false;
        this.mMediaPlayerLock.lock();
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            try {
                this.mMediaPlayer.pause();
            }
            catch (Exception e) {
                this.mMediaPlayerLock.unlock();
                DebugLog.LOGE("Could not pause playback");
            }
            this.mCurrentState = MEDIA_STATE.PAUSED;
            result = true;
        }
        this.mMediaPlayerLock.unlock();
        return result;
    }

    public boolean stop() {
        if (!this.isPlayableOnTexture()) {
            return false;
        }
        if (this.mCurrentState == MEDIA_STATE.NOT_READY || this.mCurrentState == MEDIA_STATE.ERROR) {
            return false;
        }
        boolean result = false;
        this.mMediaPlayerLock.lock();
        if (this.mMediaPlayer != null) {
            this.mCurrentState = MEDIA_STATE.STOPPED;
            try {
                this.mMediaPlayer.stop();
            }
            catch (Exception e) {
                this.mMediaPlayerLock.unlock();
                DebugLog.LOGE("Could not stop playback");
            }
            result = true;
        }
        this.mMediaPlayerLock.unlock();
        return result;
    }

    public int updateVideoData() {
        if (!this.isPlayableOnTexture()) {
            return MEDIA_STATE.NOT_READY.type;
        }
        int result = MEDIA_STATE.NOT_READY.type;
        this.mSurfaceTextureLock.lock();
        if (this.mSurfaceTexture != null) {
            if (this.mCurrentState == MEDIA_STATE.PLAYING) {
                try {
                    _updateTexImageFunc.invoke(this.mSurfaceTexture, new Object[0]);
                    float[] mtx = new float[16];
                    Object[] argList = new Object[]{mtx};
                    _getTransformMatrixFunc.invoke(this.mSurfaceTexture, argList);
                    this.copyTexture(this.mMediaTextureID, this.mDestTextureID, this.mFBO, mtx, this.mMediaPlayer.getVideoWidth(), this.mMediaPlayer.getVideoHeight());
                }
                catch (Exception e) {
                    DebugLog.LOGE("Error in updateVideoData: " + e.getMessage());
                    result = MEDIA_STATE.ERROR.type;
                }
            }
            result = this.mCurrentState.type;
        }
        this.mSurfaceTextureLock.unlock();
        return result;
    }

    public boolean seekTo(float position) {
        if (!this.isPlayableOnTexture()) {
            return false;
        }
        if (this.mCurrentState == MEDIA_STATE.NOT_READY || this.mCurrentState == MEDIA_STATE.ERROR) {
            return false;
        }
        boolean result = false;
        this.mMediaPlayerLock.lock();
        if (this.mMediaPlayer != null) {
            try {
                this.mMediaPlayer.seekTo((int)position * 1000);
            }
            catch (Exception e) {
                this.mMediaPlayerLock.unlock();
                DebugLog.LOGE("Could not seek to position");
            }
            result = true;
        }
        this.mMediaPlayerLock.unlock();
        return result;
    }

    public float getCurrentPosition() {
        if (!this.isPlayableOnTexture()) {
            return -1.0f;
        }
        if (this.mCurrentState == MEDIA_STATE.NOT_READY || this.mCurrentState == MEDIA_STATE.ERROR) {
            return -1.0f;
        }
        float result = -1.0f;
        this.mMediaPlayerLock.lock();
        if (this.mMediaPlayer != null) {
            result = (float)this.mMediaPlayer.getCurrentPosition() / 1000.0f;
        }
        this.mMediaPlayerLock.unlock();
        return result;
    }

    public boolean setVolume(float value) {
        if (!this.isPlayableOnTexture()) {
            return false;
        }
        if (this.mCurrentState == MEDIA_STATE.NOT_READY || this.mCurrentState == MEDIA_STATE.ERROR) {
            return false;
        }
        boolean result = false;
        this.mMediaPlayerLock.lock();
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setVolume(value, value);
            result = true;
        }
        this.mMediaPlayerLock.unlock();
        return result;
    }

    public int getCurrentBufferingPercentage() {
        return this.mCurrentBufferingPercentage;
    }

    public void onBufferingUpdate(MediaPlayer arg0, int arg1) {
        this.mMediaPlayerLock.lock();
        if (this.mMediaPlayer != null && arg0 == this.mMediaPlayer) {
            this.mCurrentBufferingPercentage = arg1;
        }
        this.mMediaPlayerLock.unlock();
    }

    public void setActivity(Activity newActivity) {
        this.mParentActivity = newActivity;
    }

    public void onCompletion(MediaPlayer arg0) {
        this.mCurrentState = MEDIA_STATE.REACHED_END;
    }

    public boolean setupSurfaceTexture(int nativeTextureID) {
        if (Build.VERSION.SDK_INT >= 14) {
            Object[] argList = new Object[]{new Integer(nativeTextureID)};
            try {
                this.mSurfaceTexture = _surfaceTextureConstructor.newInstance(argList);
            }
            catch (Exception e) {
                DebugLog.LOGE("Error in setupSurfaceTexture: " + e.getMessage());
                return false;
            }
            this.mTextureID = nativeTextureID;
            return true;
        }
        return false;
    }

    public void onPrepared(MediaPlayer mediaplayer) {
        this.mCurrentState = MEDIA_STATE.READY;
        if (this.mShouldPlayImmediately) {
            this.play(false, this.mSeekPosition);
        }
        this.mSeekPosition = 0.0f;
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        DebugLog.LOGE("Error while opening the file. Unloading the media player");
        this.unload();
        this.mCurrentState = MEDIA_STATE.ERROR;
        return true;
    }

    public boolean setVideoTextureID(int textureID) {
        if (!this.isPlayableOnTexture() || this.mMediaPlayer == null) {
            DebugLog.LOGD("Cannot set the video texture ID if it is not playable on texture");
            return false;
        }
        this.mDestTextureID = textureID;
        int videoWidth = this.mMediaPlayer.getVideoWidth();
        int videoHeight = this.mMediaPlayer.getVideoHeight();
        if (videoWidth > 0 && videoHeight > 0) {
            this.mFBO = this.initFBO(this.mDestTextureID, videoWidth, videoHeight);
            return true;
        }
        return false;
    }

    public boolean isFileInAssetsFolder(String filename) {
        AssetFileDescriptor afd = null;
        try {
            afd = this.mParentActivity.getAssets().openFd(filename);
        }
        catch (IOException e) {
            afd = null;
        }
        return afd != null;
    }

    public static Method retrieveClassMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        Method classMethod = null;
        try {
            classMethod = cls.getMethod(name, parameterTypes);
        }
        catch (Exception e) {
            DebugLog.LOGE("Failed to retrieve method '" + name + "' at API level " + Build.VERSION.SDK_INT + ": " + e.toString());
        }
        return classMethod;
    }

    static {
        VideoPlayerHelper.loadLibrary("VuforiaMedia");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MEDIA_TYPE {
        ON_TEXTURE(0),
        FULLSCREEN(1),
        ON_TEXTURE_FULLSCREEN(2),
        UNKNOWN(3);

        private int type;

        private MEDIA_TYPE(int i) {
            this.type = i;
        }

        public int getNumericType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MEDIA_STATE {
        REACHED_END(0),
        PAUSED(1),
        STOPPED(2),
        PLAYING(3),
        READY(4),
        NOT_READY(5),
        ERROR(6);

        private int type;

        private MEDIA_STATE(int i) {
            this.type = i;
        }

        public int getNumericType() {
            return this.type;
        }
    }
}

