/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.provider.play27;

import com.google.code.play2.provider.api.AssetCompilationException;
import com.google.code.play2.provider.api.JavascriptCompilationResult;
import com.google.code.play2.provider.api.Play2JavascriptCompiler;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Play27JavascriptCompiler
implements Play2JavascriptCompiler {
    private List<String> compilerOptions = Collections.emptyList();

    public void setCompilerOptions(List<String> compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public CompileResult compile(File source) throws AssetCompilationException, IOException {
        boolean requireJsMode = this.compilerOptions.contains("rjs");
        boolean commonJsMode = this.compilerOptions.contains("commonJs") && !requireJsMode;
        String origin = this.readFileContent(source);
        CompilerOptions options = this.getOptions(source, commonJsMode);
        Compiler compiler = new Compiler();
        List<File> all = this.allSiblings(source);
        ArrayList<SourceFile> inputs = new ArrayList<SourceFile>();
        if (commonJsMode) {
            for (File f : all) {
                inputs.add(SourceFile.fromFile((File)f));
            }
        } else {
            inputs.add(SourceFile.fromFile((File)source));
        }
        try {
            List externs = Collections.emptyList();
            Result result = compiler.compile(externs, inputs, options);
            if (result.success) {
                String minifiedJs = null;
                if (!requireJsMode) {
                    minifiedJs = compiler.toSource();
                }
                return new CompileResult(origin, minifiedJs, null);
            }
            JSError error = compiler.getErrors()[0];
            File errorFile = null;
            for (File f : all) {
                if (!f.getAbsolutePath().equals(error.sourceName)) continue;
                errorFile = f;
                break;
            }
            throw new AssetCompilationException(errorFile, error.description, error.lineNumber, 0);
        }
        catch (Exception e) {
            throw new AssetCompilationException((Throwable)e, source, "Internal Closure Compiler error (see logs)", 0, 0);
        }
    }

    private CompilerOptions getOptions(File source, boolean commonJsMode) {
        CompilerOptions defaultOptions = new CompilerOptions();
        defaultOptions.closurePass = true;
        if (commonJsMode) {
            defaultOptions.setProcessCommonJSModules(true);
            defaultOptions.setCommonJSModulePathPrefix((source.getParent() + File.separator).replaceAll("\\\\", "/"));
            ArrayList<String> entryPoints = new ArrayList<String>(1);
            entryPoints.add(this.toModuleName(source.getName()));
            defaultOptions.setManageClosureDependencies(entryPoints);
        }
        for (String opt : this.compilerOptions) {
            if ("advancedOptimizations".equals(opt)) {
                CompilationLevel.ADVANCED_OPTIMIZATIONS.setOptionsForCompilationLevel(defaultOptions);
                continue;
            }
            if ("checkTypes".equals(opt)) {
                defaultOptions.setCheckTypes(true);
                continue;
            }
            if ("checkSymbols".equals(opt)) {
                defaultOptions.setCheckSymbols(true);
                continue;
            }
            if (!"ecmascript5".equals(opt)) continue;
            defaultOptions.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT5);
        }
        return defaultOptions;
    }

    public String minify(String source, String name) throws AssetCompilationException {
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        if (name == null) {
            name = "unknown";
        }
        ArrayList<SourceFile> inputs = new ArrayList<SourceFile>(1);
        inputs.add(SourceFile.fromCode((String)name, (String)source));
        List externs = Collections.emptyList();
        if (compiler.compile(externs, inputs, (CompilerOptions)options).success) {
            return compiler.toSource();
        }
        JSError error = compiler.getErrors()[0];
        throw new AssetCompilationException(null, error.description, error.lineNumber, 0);
    }

    private String toModuleName(String filename) {
        return "module$" + filename.replaceAll("^\\./", "").replaceAll("/", "\\$").replaceAll("\\.js$", "").replaceAll("-", "_");
    }

    private List<File> allSiblings(File source) {
        return this.allJsFilesIn(source.getParentFile());
    }

    private List<File> allJsFilesIn(File dir) {
        File[] directories;
        ArrayList<File> result = new ArrayList<File>();
        File[] jsFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".js");
            }
        });
        result.addAll(Arrays.asList(jsFiles));
        for (File directory : directories = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) {
            result.addAll(this.allJsFilesIn(directory));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileContent(File file) throws IOException {
        String result = null;
        try (BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            StringBuilder sb = new StringBuilder();
            String line = is.readLine();
            while (line != null) {
                sb.append(line).append('\n');
                line = is.readLine();
            }
            result = sb.toString();
        }
        return result;
    }

    public static class CompileResult
    implements JavascriptCompilationResult {
        private String js;
        private String minifiedJs;
        private List<File> dependencies;

        public CompileResult(String js, String minifiedJs, List<File> dependencies) {
            this.js = js;
            this.minifiedJs = minifiedJs;
            this.dependencies = dependencies;
        }

        public String getJs() {
            return this.js;
        }

        public String getMinifiedJs() {
            return this.minifiedJs;
        }

        public List<File> getDependencies() {
            return this.dependencies;
        }
    }
}

