/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.glassfish.jersey.internal.guava;

import com.github.dockerjava.shaded.org.glassfish.jersey.internal.guava.Preconditions;
import com.github.dockerjava.shaded.org.glassfish.jersey.internal.guava.UnmodifiableIterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<T>
extends UnmodifiableIterator<T> {
    private State state = State.NOT_READY;
    private T next;

    AbstractIterator() {
    }

    protected abstract T computeNext();

    final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        Preconditions.checkState(this.state != State.FAILED);
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        T result = this.next;
        this.next = null;
        return result;
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

