/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.io.netty.handler.codec.socks;

import com.github.dockerjava.shaded.io.netty.buffer.ByteBuf;
import com.github.dockerjava.shaded.io.netty.handler.codec.socks.SocksAuthScheme;
import com.github.dockerjava.shaded.io.netty.handler.codec.socks.SocksRequest;
import com.github.dockerjava.shaded.io.netty.handler.codec.socks.SocksRequestType;
import java.util.Collections;
import java.util.List;

public final class SocksInitRequest
extends SocksRequest {
    private final List<SocksAuthScheme> authSchemes;

    public SocksInitRequest(List<SocksAuthScheme> authSchemes) {
        super(SocksRequestType.INIT);
        if (authSchemes == null) {
            throw new NullPointerException("authSchemes");
        }
        this.authSchemes = authSchemes;
    }

    public List<SocksAuthScheme> authSchemes() {
        return Collections.unmodifiableList(this.authSchemes);
    }

    @Override
    public void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(this.protocolVersion().byteValue());
        byteBuf.writeByte(this.authSchemes.size());
        for (SocksAuthScheme authScheme : this.authSchemes) {
            byteBuf.writeByte(authScheme.byteValue());
        }
    }
}

