/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.util.FiltersEncoder;
import com.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;
import com.github.dockerjava.shaded.com.google.common.net.UrlEscapers;
import com.github.dockerjava.shaded.javax.ws.rs.client.WebTarget;
import com.github.dockerjava.shaded.javax.ws.rs.core.GenericType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListImagesCmdExec
extends AbstrSyncDockerCmdExec<ListImagesCmd, List<Image>>
implements ListImagesCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListImagesCmdExec.class);

    public ListImagesCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Image> execute(ListImagesCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/images/json");
        webTarget = this.booleanQueryParam(webTarget, "all", command.hasShowAllEnabled());
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode(command.getFilters())));
        }
        if (command.getImageNameFilter() != null) {
            webTarget = webTarget.queryParam("filter", UrlEscapers.urlPathSegmentEscaper().escape(command.getImageNameFilter()));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<Image> images = webTarget.request().accept("application/json").get(new GenericType<List<Image>>(){});
        LOGGER.trace("Response: {}", (Object)images);
        return images;
    }
}

