/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.PropagationMode;
import com.github.dockerjava.api.model.SELContext;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.shaded.org.apache.commons.lang.builder.EqualsBuilder;
import com.github.dockerjava.shaded.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.Serializable;

public class Bind
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String path;
    private Volume volume;
    private AccessMode accessMode;
    private Boolean noCopy;
    private SELContext secMode;
    private PropagationMode propagationMode;

    public Bind(String path, Volume volume) {
        this(path, volume, AccessMode.DEFAULT, SELContext.DEFAULT);
    }

    public Bind(String path, Volume volume, Boolean noCopy) {
        this(path, volume, AccessMode.DEFAULT, SELContext.DEFAULT, noCopy);
    }

    public Bind(String path, Volume volume, AccessMode accessMode) {
        this(path, volume, accessMode, SELContext.DEFAULT);
    }

    public Bind(String path, Volume volume, AccessMode accessMode, SELContext secMode) {
        this(path, volume, accessMode, secMode, null);
    }

    public Bind(String path, Volume volume, AccessMode accessMode, SELContext secMode, Boolean noCopy) {
        this(path, volume, accessMode, secMode, noCopy, PropagationMode.DEFAULT_MODE);
    }

    public Bind(String path, Volume volume, AccessMode accessMode, SELContext secMode, Boolean noCopy, PropagationMode propagationMode) {
        this.path = path;
        this.volume = volume;
        this.accessMode = accessMode;
        this.secMode = secMode;
        this.noCopy = noCopy;
        this.propagationMode = propagationMode;
    }

    public String getPath() {
        return this.path;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public SELContext getSecMode() {
        return this.secMode;
    }

    public Boolean getNoCopy() {
        return this.noCopy;
    }

    public PropagationMode getPropagationMode() {
        return this.propagationMode;
    }

    public static Bind parse(String serialized) {
        try {
            String[] parts = serialized.split(":");
            switch (parts.length) {
                case 2: {
                    return new Bind(parts[0], new Volume(parts[1]));
                }
                case 3: {
                    String[] flags = parts[2].split(",");
                    AccessMode accessMode = AccessMode.DEFAULT;
                    SELContext seMode = SELContext.DEFAULT;
                    Boolean nocopy = null;
                    PropagationMode propagationMode = PropagationMode.DEFAULT_MODE;
                    for (String p : flags) {
                        if (p.length() == 2) {
                            accessMode = AccessMode.valueOf(p.toLowerCase());
                            continue;
                        }
                        if ("nocopy".equals(p)) {
                            nocopy = true;
                            continue;
                        }
                        if (PropagationMode.SHARED.toString().equals(p)) {
                            propagationMode = PropagationMode.SHARED;
                            continue;
                        }
                        if (PropagationMode.SLAVE.toString().equals(p)) {
                            propagationMode = PropagationMode.SLAVE;
                            continue;
                        }
                        if (PropagationMode.PRIVATE.toString().equals(p)) {
                            propagationMode = PropagationMode.PRIVATE;
                            continue;
                        }
                        seMode = SELContext.fromString(p);
                    }
                    return new Bind(parts[0], new Volume(parts[1]), accessMode, seMode, nocopy, propagationMode);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing Bind '" + serialized + "'", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bind) {
            Bind other = (Bind)obj;
            return new EqualsBuilder().append(this.path, other.getPath()).append(this.volume, other.getVolume()).append((Object)this.accessMode, (Object)other.getAccessMode()).append((Object)this.secMode, (Object)other.getSecMode()).append(this.noCopy, other.getNoCopy()).append((Object)this.propagationMode, (Object)other.getPropagationMode()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.path).append(this.volume).append((Object)this.accessMode).append((Object)this.secMode).append(this.noCopy).append((Object)this.propagationMode).toHashCode();
    }

    public String toString() {
        return String.format("%s:%s:%s%s%s%s", this.path, this.volume.getPath(), this.accessMode.toString(), this.secMode != SELContext.none ? "," + this.secMode.toString() : "", this.noCopy != null ? ",nocopy" : "", this.propagationMode != PropagationMode.DEFAULT_MODE ? "," + this.propagationMode.toString() : "");
    }
}

