/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.types;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumeratedAttribute {
    protected String value;
    private int index = -1;

    public abstract String[] getValues();

    protected EnumeratedAttribute() {
    }

    public static EnumeratedAttribute getInstance(Class<? extends EnumeratedAttribute> clazz, String value) throws BuildException {
        if (!EnumeratedAttribute.class.isAssignableFrom(clazz)) {
            throw new BuildException("You have to provide a subclass from EnumeratedAttribut as clazz-parameter.");
        }
        EnumeratedAttribute ea = null;
        try {
            ea = clazz.newInstance();
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
        ea.setValue(value);
        return ea;
    }

    public final void setValue(String value) throws BuildException {
        int idx = this.indexOfValue(value);
        if (idx == -1) {
            throw new BuildException(value + " is not a legal value for this attribute");
        }
        this.index = idx;
        this.value = value;
    }

    public final boolean containsValue(String value) {
        return this.indexOfValue(value) != -1;
    }

    public final int indexOfValue(String value) {
        String[] values = this.getValues();
        if (values == null || value == null) {
            return -1;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!value.equals(values[i])) continue;
            return i;
        }
        return -1;
    }

    public final String getValue() {
        return this.value;
    }

    public final int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.getValue();
    }
}

