/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty;

import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.AbstractDockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.netty.ChannelProvider;
import com.github.dockerjava.netty.NettyWebTarget;
import com.github.dockerjava.shaded.com.google.common.base.Preconditions;
import com.github.dockerjava.shaded.io.netty.bootstrap.Bootstrap;
import com.github.dockerjava.shaded.io.netty.channel.Channel;
import com.github.dockerjava.shaded.io.netty.channel.ChannelConfig;
import com.github.dockerjava.shaded.io.netty.channel.ChannelFactory;
import com.github.dockerjava.shaded.io.netty.channel.ChannelHandler;
import com.github.dockerjava.shaded.io.netty.channel.ChannelHandlerContext;
import com.github.dockerjava.shaded.io.netty.channel.ChannelInitializer;
import com.github.dockerjava.shaded.io.netty.channel.EventLoopGroup;
import com.github.dockerjava.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import com.github.dockerjava.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import com.github.dockerjava.shaded.io.netty.channel.kqueue.KQueueDomainSocketChannel;
import com.github.dockerjava.shaded.io.netty.channel.kqueue.KQueueEventLoopGroup;
import com.github.dockerjava.shaded.io.netty.channel.nio.NioEventLoopGroup;
import com.github.dockerjava.shaded.io.netty.channel.socket.DuplexChannel;
import com.github.dockerjava.shaded.io.netty.channel.socket.SocketChannel;
import com.github.dockerjava.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import com.github.dockerjava.shaded.io.netty.channel.unix.DomainSocketAddress;
import com.github.dockerjava.shaded.io.netty.channel.unix.UnixChannel;
import com.github.dockerjava.shaded.io.netty.handler.codec.http.HttpClientCodec;
import com.github.dockerjava.shaded.io.netty.handler.codec.http.HttpContentDecompressor;
import com.github.dockerjava.shaded.io.netty.handler.logging.LoggingHandler;
import com.github.dockerjava.shaded.io.netty.handler.ssl.SslHandler;
import com.github.dockerjava.shaded.io.netty.handler.timeout.IdleState;
import com.github.dockerjava.shaded.io.netty.handler.timeout.IdleStateEvent;
import com.github.dockerjava.shaded.io.netty.handler.timeout.IdleStateHandler;
import com.github.dockerjava.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import com.github.dockerjava.shaded.org.apache.commons.lang.SystemUtils;
import com.github.dockerjava.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.security.Security;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class NettyDockerCmdExecFactory
extends AbstractDockerCmdExecFactory
implements DockerCmdExecFactory {
    private static String threadPrefix = "dockerjava-netty";
    private Bootstrap bootstrap;
    private EventLoopGroup eventLoopGroup;
    private NettyInitializer nettyInitializer;
    private WebTarget baseResource;
    private ChannelProvider channelProvider = new ChannelProvider(){

        @Override
        public DuplexChannel getChannel() {
            DuplexChannel channel = NettyDockerCmdExecFactory.this.connect();
            channel.pipeline().addLast(new LoggingHandler(this.getClass()));
            return channel;
        }
    };
    private Integer connectTimeout = null;
    private Integer readTimeout = null;

    @Override
    public void init(DockerClientConfig dockerClientConfig) {
        super.init(dockerClientConfig);
        this.bootstrap = new Bootstrap();
        String scheme = dockerClientConfig.getDockerHost().getScheme();
        String host = "";
        if ("unix".equals(scheme)) {
            this.nettyInitializer = new UnixDomainSocketInitializer();
            host = "DUMMY";
        } else if ("tcp".equals(scheme)) {
            this.nettyInitializer = new InetSocketInitializer();
            host = dockerClientConfig.getDockerHost().getHost() + ":" + Integer.toString(dockerClientConfig.getDockerHost().getPort());
        }
        this.eventLoopGroup = this.nettyInitializer.init(this.bootstrap, dockerClientConfig);
        this.baseResource = new NettyWebTarget(this.channelProvider, host).path(dockerClientConfig.getApiVersion().asWebPathPart());
    }

    private DuplexChannel connect() {
        try {
            return this.connect(this.bootstrap);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
        return this.nettyInitializer.connect(bootstrap);
    }

    public SSLParameters enableHostNameVerification(SSLParameters sslParameters) {
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        return sslParameters;
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkNotNull(this.eventLoopGroup, "Factory not initialized. You probably forgot to call init()!");
        this.eventLoopGroup.shutdownGracefully();
    }

    public NettyDockerCmdExecFactory withConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public NettyDockerCmdExecFactory withReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    private <T extends Channel> T configure(T channel) {
        ChannelConfig channelConfig = channel.config();
        if (this.connectTimeout != null) {
            channelConfig.setConnectTimeoutMillis(this.connectTimeout);
        }
        if (this.readTimeout != null) {
            channel.pipeline().addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler());
        }
        return channel;
    }

    @Override
    protected WebTarget getBaseResource() {
        Preconditions.checkNotNull(this.baseResource, "Factory not initialized, baseResource not set. You probably forgot to call init()!");
        return this.baseResource;
    }

    private final class ReadTimeoutHandler
    extends IdleStateHandler {
        private boolean alreadyTimedOut;

        ReadTimeoutHandler() {
            super(NettyDockerCmdExecFactory.this.readTimeout.intValue(), 0L, 0L, TimeUnit.MILLISECONDS);
        }

        @Override
        protected synchronized void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            assert (evt.state() == IdleState.READER_IDLE);
            Channel channel = ctx.channel();
            if (channel == null || !channel.isActive() || this.alreadyTimedOut) {
                return;
            }
            DockerClientConfig dockerClientConfig = NettyDockerCmdExecFactory.this.getDockerClientConfig();
            URI dockerAPIEndpoint = dockerClientConfig.getDockerHost();
            String msg = "Read timed out: No data received within " + NettyDockerCmdExecFactory.this.readTimeout + "ms.  Perhaps the docker API (" + dockerAPIEndpoint + ") is not responding normally, or perhaps you need to increase the readTimeout value.";
            SocketTimeoutException ex = new SocketTimeoutException(msg);
            ctx.fireExceptionCaught(ex);
            this.alreadyTimedOut = true;
        }
    }

    private class InetSocketInitializer
    implements NettyInitializer {
        private InetSocketInitializer() {
        }

        @Override
        public EventLoopGroup init(Bootstrap bootstrap, DockerClientConfig dockerClientConfig) {
            NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(0, new DefaultThreadFactory(threadPrefix));
            InetAddress addr = InetAddress.getLoopbackAddress();
            InetSocketAddress proxyAddress = new InetSocketAddress(addr, 8008);
            Security.addProvider(new BouncyCastleProvider());
            ChannelFactory<NioSocketChannel> factory = new ChannelFactory<NioSocketChannel>(){

                @Override
                public NioSocketChannel newChannel() {
                    return (NioSocketChannel)NettyDockerCmdExecFactory.this.configure(new NioSocketChannel());
                }
            };
            ((Bootstrap)((Bootstrap)bootstrap.group(nioEventLoopGroup)).channelFactory(factory)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new HttpClientCodec());
                    channel.pipeline().addLast(new HttpContentDecompressor());
                }
            });
            return nioEventLoopGroup;
        }

        @Override
        public DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
            DockerClientConfig dockerClientConfig = NettyDockerCmdExecFactory.this.getDockerClientConfig();
            String host = dockerClientConfig.getDockerHost().getHost();
            int port = dockerClientConfig.getDockerHost().getPort();
            if (port == -1) {
                throw new RuntimeException("no port configured for " + host);
            }
            DuplexChannel channel = (DuplexChannel)bootstrap.connect(host, port).sync().channel();
            SslHandler ssl = this.initSsl(dockerClientConfig);
            if (ssl != null) {
                channel.pipeline().addFirst(ssl);
            }
            return channel;
        }

        private SslHandler initSsl(DockerClientConfig dockerClientConfig) {
            SslHandler ssl = null;
            try {
                String host = dockerClientConfig.getDockerHost().getHost();
                int port = dockerClientConfig.getDockerHost().getPort();
                SSLConfig sslConfig = dockerClientConfig.getSSLConfig();
                if (sslConfig != null && sslConfig.getSSLContext() != null) {
                    SSLEngine engine = sslConfig.getSSLContext().createSSLEngine(host, port);
                    engine.setUseClientMode(true);
                    engine.setSSLParameters(NettyDockerCmdExecFactory.this.enableHostNameVerification(engine.getSSLParameters()));
                    ssl = new SslHandler(engine);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ssl;
        }
    }

    private class UnixDomainSocketInitializer
    implements NettyInitializer {
        private UnixDomainSocketInitializer() {
        }

        @Override
        public EventLoopGroup init(Bootstrap bootstrap, DockerClientConfig dockerClientConfig) {
            if (SystemUtils.IS_OS_LINUX) {
                return this.epollGroup();
            }
            if (SystemUtils.IS_OS_MAC_OSX) {
                return this.kqueueGroup();
            }
            throw new RuntimeException("Unsupported OS");
        }

        public EventLoopGroup epollGroup() {
            EpollEventLoopGroup epollEventLoopGroup = new EpollEventLoopGroup(0, new DefaultThreadFactory(threadPrefix));
            ChannelFactory<EpollDomainSocketChannel> factory = new ChannelFactory<EpollDomainSocketChannel>(){

                @Override
                public EpollDomainSocketChannel newChannel() {
                    return (EpollDomainSocketChannel)NettyDockerCmdExecFactory.this.configure(new EpollDomainSocketChannel());
                }
            };
            ((Bootstrap)((Bootstrap)NettyDockerCmdExecFactory.this.bootstrap.group(epollEventLoopGroup)).channelFactory(factory)).handler(new ChannelInitializer<UnixChannel>(){

                @Override
                protected void initChannel(UnixChannel channel) throws Exception {
                    channel.pipeline().addLast(new HttpClientCodec());
                    channel.pipeline().addLast(new HttpContentDecompressor());
                }
            });
            return epollEventLoopGroup;
        }

        public EventLoopGroup kqueueGroup() {
            KQueueEventLoopGroup nioEventLoopGroup = new KQueueEventLoopGroup(0, new DefaultThreadFactory(threadPrefix));
            ((Bootstrap)((Bootstrap)NettyDockerCmdExecFactory.this.bootstrap.group(nioEventLoopGroup)).channel(KQueueDomainSocketChannel.class)).handler(new ChannelInitializer<KQueueDomainSocketChannel>(){

                @Override
                protected void initChannel(KQueueDomainSocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new LoggingHandler(this.getClass()));
                    channel.pipeline().addLast(new HttpClientCodec());
                    channel.pipeline().addLast(new HttpContentDecompressor());
                }
            });
            return nioEventLoopGroup;
        }

        @Override
        public DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
            DockerClientConfig dockerClientConfig = NettyDockerCmdExecFactory.this.getDockerClientConfig();
            String path = dockerClientConfig.getDockerHost().getPath();
            return (DuplexChannel)bootstrap.connect(new DomainSocketAddress(path)).sync().channel();
        }
    }

    private static interface NettyInitializer {
        public EventLoopGroup init(Bootstrap var1, DockerClientConfig var2);

        public DuplexChannel connect(Bootstrap var1) throws InterruptedException;
    }
}

