/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.commons.compress.archivers;

import com.github.dockerjava.shaded.org.apache.commons.compress.archivers.ArchiveEntry;
import com.github.dockerjava.shaded.org.apache.commons.compress.archivers.ArchiveException;
import com.github.dockerjava.shaded.org.apache.commons.compress.archivers.ArchiveInputStream;
import com.github.dockerjava.shaded.org.apache.commons.compress.archivers.ArchiveStreamFactory;
import com.github.dockerjava.shaded.org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import com.github.dockerjava.shaded.org.apache.commons.compress.archivers.sevenz.SevenZFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public final class Lister {
    private static final ArchiveStreamFactory factory = new ArchiveStreamFactory();

    public static void main(String[] args) throws Exception {
        String format;
        if (args.length == 0) {
            Lister.usage();
            return;
        }
        System.out.println("Analysing " + args[0]);
        File f = new File(args[0]);
        if (!f.isFile()) {
            System.err.println(f + " doesn't exist or is a directory");
        }
        String string = format = args.length > 1 ? args[1] : Lister.detectFormat(f);
        if ("7z".equalsIgnoreCase(format)) {
            Lister.list7z(f);
        } else {
            Lister.listStream(f, args);
        }
    }

    private static void listStream(File f, String[] args) throws ArchiveException, IOException {
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));
             ArchiveInputStream ais = Lister.createArchiveInputStream(args, fis);){
            ArchiveEntry ae;
            System.out.println("Created " + ais.toString());
            while ((ae = ais.getNextEntry()) != null) {
                System.out.println(ae.getName());
            }
        }
    }

    private static ArchiveInputStream createArchiveInputStream(String[] args, InputStream fis) throws ArchiveException {
        if (args.length > 1) {
            return factory.createArchiveInputStream(args[1], fis);
        }
        return factory.createArchiveInputStream(fis);
    }

    private static String detectFormat(File f) throws ArchiveException, IOException {
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));){
            String string = ArchiveStreamFactory.detect(fis);
            return string;
        }
    }

    private static void list7z(File f) throws ArchiveException, IOException {
        try (SevenZFile z = new SevenZFile(f);){
            SevenZArchiveEntry ae;
            System.out.println("Created " + z.toString());
            while ((ae = z.getNextEntry()) != null) {
                System.out.println(ae.getName());
            }
        }
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [archive-type]");
    }
}

