/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;

class ProcessDestroyer
implements Runnable {
    private static final int THREAD_DIE_TIMEOUT = 20000;
    private HashSet processes = new HashSet();
    private Method addShutdownHookMethod;
    private Method removeShutdownHookMethod;
    private ProcessDestroyerImpl destroyProcessThread = null;
    private boolean added = false;
    private boolean running = false;

    ProcessDestroyer() {
        try {
            Class[] paramTypes = new Class[]{Thread.class};
            this.addShutdownHookMethod = Runtime.class.getMethod("addShutdownHook", paramTypes);
            this.removeShutdownHookMethod = Runtime.class.getMethod("removeShutdownHook", paramTypes);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addShutdownHook() {
        if (this.addShutdownHookMethod != null && !this.running) {
            this.destroyProcessThread = new ProcessDestroyerImpl();
            Object[] args = new Object[]{this.destroyProcessThread};
            try {
                this.addShutdownHookMethod.invoke((Object)Runtime.getRuntime(), args);
                this.added = true;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t != null && t.getClass() == IllegalStateException.class) {
                    this.running = true;
                }
                e.printStackTrace();
            }
        }
    }

    private void removeShutdownHook() {
        if (this.removeShutdownHookMethod != null && this.added && !this.running) {
            Object[] args = new Object[]{this.destroyProcessThread};
            try {
                Boolean removed = (Boolean)this.removeShutdownHookMethod.invoke((Object)Runtime.getRuntime(), args);
                if (!removed.booleanValue()) {
                    System.err.println("Could not remove shutdown hook");
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t != null && t.getClass() == IllegalStateException.class) {
                    this.running = true;
                }
                e.printStackTrace();
            }
            this.destroyProcessThread.setShouldDestroy(false);
            if (!this.destroyProcessThread.getThreadGroup().isDestroyed()) {
                this.destroyProcessThread.start();
            }
            try {
                this.destroyProcessThread.join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.destroyProcessThread = null;
            this.added = false;
        }
    }

    public boolean isAddedAsShutdownHook() {
        return this.added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Process process) {
        HashSet hashSet = this.processes;
        synchronized (hashSet) {
            if (this.processes.size() == 0) {
                this.addShutdownHook();
            }
            return this.processes.add(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Process process) {
        HashSet hashSet = this.processes;
        synchronized (hashSet) {
            boolean processRemoved = this.processes.remove(process);
            if (processRemoved && this.processes.size() == 0) {
                this.removeShutdownHook();
            }
            return processRemoved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HashSet hashSet = this.processes;
        synchronized (hashSet) {
            this.running = true;
            Iterator e = this.processes.iterator();
            while (e.hasNext()) {
                ((Process)e.next()).destroy();
            }
        }
    }

    private class ProcessDestroyerImpl
    extends Thread {
        private boolean shouldDestroy;

        public ProcessDestroyerImpl() {
            super("ProcessDestroyer Shutdown Hook");
            this.shouldDestroy = true;
        }

        public void run() {
            if (this.shouldDestroy) {
                ProcessDestroyer.this.run();
            }
        }

        public void setShouldDestroy(boolean shouldDestroy) {
            this.shouldDestroy = shouldDestroy;
        }
    }
}

