/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.github.dockerjava.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.shaded.com.fasterxml.jackson.core.type.TypeReference;
import com.github.dockerjava.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.shaded.org.apache.commons.codec.binary.Base64;
import com.github.dockerjava.shaded.org.apache.commons.io.FileUtils;
import com.github.dockerjava.shaded.org.apache.commons.lang.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DockerConfigFile {
    private static final String DOCKER_LEGACY_CFG = ".dockercfg";
    private static final String DOCKER_CFG = "config.json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, AuthConfig>> CONFIG_MAP_TYPE = new TypeReference<Map<String, AuthConfig>>(){};
    @JsonProperty
    private final Map<String, AuthConfig> auths;

    public DockerConfigFile() {
        this(new HashMap<String, AuthConfig>());
    }

    private DockerConfigFile(Map<String, AuthConfig> authConfigMap) {
        this.auths = authConfigMap;
    }

    public Map<String, AuthConfig> getAuths() {
        return this.auths;
    }

    void addAuthConfig(AuthConfig config) {
        this.auths.put(config.getRegistryAddress(), config);
    }

    public AuthConfig resolveAuthConfig(String hostname) {
        if (StringUtils.isEmpty(hostname) || "https://index.docker.io/v1/".equals(hostname)) {
            return this.auths.get("https://index.docker.io/v1/");
        }
        AuthConfig c = this.auths.get(hostname);
        if (c != null) {
            return c;
        }
        String normalizedHostname = DockerConfigFile.convertToHostname(hostname);
        for (Map.Entry<String, AuthConfig> entry : this.auths.entrySet()) {
            String registry = entry.getKey();
            AuthConfig config = entry.getValue();
            if (!DockerConfigFile.convertToHostname(registry).equals(normalizedHostname)) continue;
            return config;
        }
        return null;
    }

    public AuthConfigurations getAuthConfigurations() {
        AuthConfigurations authConfigurations = new AuthConfigurations();
        for (Map.Entry<String, AuthConfig> authConfigEntry : this.auths.entrySet()) {
            authConfigurations.addConfig(authConfigEntry.getValue());
        }
        return authConfigurations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.auths == null ? 0 : this.auths.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerConfigFile other = (DockerConfigFile)obj;
        return !(this.auths == null ? other.auths != null : !this.auths.equals(other.auths));
    }

    public String toString() {
        return "DockerConfigFile [auths=" + this.auths + "]";
    }

    public static DockerConfigFile loadConfig(File dockerConfigPath) throws IOException {
        DockerConfigFile dockerConfig = DockerConfigFile.loadCurrentConfig(dockerConfigPath);
        if (dockerConfig == null) {
            dockerConfig = DockerConfigFile.loadLegacyConfig(dockerConfigPath);
        }
        if (dockerConfig == null) {
            dockerConfig = new DockerConfigFile();
        }
        for (Map.Entry<String, AuthConfig> entry : dockerConfig.getAuths().entrySet()) {
            AuthConfig authConfig = entry.getValue();
            DockerConfigFile.decodeAuth(authConfig);
            authConfig.withAuth(null);
            authConfig.withRegistryAddress(entry.getKey());
        }
        return dockerConfig;
    }

    private static DockerConfigFile loadCurrentConfig(File dockerConfigPath) throws IOException {
        File dockerCfgFile = new File(dockerConfigPath, File.separator + DOCKER_CFG);
        if (!dockerCfgFile.exists() || !dockerCfgFile.isFile()) {
            return null;
        }
        try {
            return MAPPER.readValue(dockerCfgFile, DockerConfigFile.class);
        }
        catch (IOException e) {
            throw new IOException("Failed to parse docker config.json", e);
        }
    }

    private static DockerConfigFile loadLegacyConfig(File dockerConfigPath) throws IOException {
        File dockerLegacyCfgFile = new File(dockerConfigPath, File.separator + DOCKER_LEGACY_CFG);
        if (!dockerLegacyCfgFile.exists() || !dockerLegacyCfgFile.isFile()) {
            return null;
        }
        try {
            return new DockerConfigFile((Map)MAPPER.readValue(dockerLegacyCfgFile, CONFIG_MAP_TYPE));
        }
        catch (IOException iOException) {
            List<String> authFileContent = FileUtils.readLines(dockerLegacyCfgFile, StandardCharsets.UTF_8);
            if (authFileContent.size() < 2) {
                throw new IOException("The Auth Config file is empty");
            }
            AuthConfig config = new AuthConfig();
            String[] origAuth = authFileContent.get(0).split(" = ");
            if (origAuth.length != 2) {
                throw new IOException("Invalid Auth config file");
            }
            config.withAuth(origAuth[1]);
            String[] origEmail = authFileContent.get(1).split(" = ");
            if (origEmail.length != 2) {
                throw new IOException("Invalid Auth config file");
            }
            config.withEmail(origEmail[1]);
            return new DockerConfigFile(new HashMap<String, AuthConfig>(Collections.singletonMap(config.getRegistryAddress(), config)));
        }
    }

    private static void decodeAuth(AuthConfig config) throws IOException {
        if (config.getAuth() == null) {
            return;
        }
        String str = new String(Base64.decodeBase64(config.getAuth()), StandardCharsets.UTF_8);
        String[] parts = str.split(":", 2);
        if (parts.length != 2) {
            throw new IOException("Invalid auth configuration file");
        }
        config.withUsername(parts[0]);
        config.withPassword(parts[1]);
    }

    static String convertToHostname(String server) {
        String stripped = server;
        if (server.startsWith("http://")) {
            stripped = server.substring(7);
        } else if (server.startsWith("https://")) {
            stripped = server.substring(8);
        }
        String[] numParts = stripped.split("/", 2);
        return numParts[0];
    }
}

