/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.jce.provider;

import com.github.dockerjava.shaded.org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.github.dockerjava.shaded.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.github.dockerjava.shaded.org.bouncycastle.jcajce.provider.config.ProviderConfigurationPermission;
import com.github.dockerjava.shaded.org.bouncycastle.jce.spec.ECParameterSpec;
import java.security.Permission;
import javax.crypto.spec.DHParameterSpec;

class BouncyCastleProviderConfiguration
implements ProviderConfiguration {
    private static Permission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission("BC", "threadLocalEcImplicitlyCa");
    private static Permission BC_EC_PERMISSION = new ProviderConfigurationPermission("BC", "ecImplicitlyCa");
    private static Permission BC_DH_LOCAL_PERMISSION = new ProviderConfigurationPermission("BC", "threadLocalDhDefaultParams");
    private static Permission BC_DH_PERMISSION = new ProviderConfigurationPermission("BC", "DhDefaultParams");
    private ThreadLocal ecThreadSpec = new ThreadLocal();
    private ThreadLocal dhThreadSpec = new ThreadLocal();
    private volatile ECParameterSpec ecImplicitCaParams;
    private volatile Object dhDefaultParams;

    BouncyCastleProviderConfiguration() {
    }

    void setParameter(String string, Object object) {
        SecurityManager securityManager = System.getSecurityManager();
        if (string.equals("threadLocalEcImplicitlyCa")) {
            ECParameterSpec eCParameterSpec;
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            if ((eCParameterSpec = object instanceof ECParameterSpec || object == null ? (ECParameterSpec)object : EC5Util.convertSpec((java.security.spec.ECParameterSpec)object, false)) == null) {
                this.ecThreadSpec.remove();
            } else {
                this.ecThreadSpec.set(eCParameterSpec);
            }
        } else if (string.equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            this.ecImplicitCaParams = object instanceof ECParameterSpec || object == null ? (ECParameterSpec)object : EC5Util.convertSpec((java.security.spec.ECParameterSpec)object, false);
        } else if (string.equals("threadLocalDhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_LOCAL_PERMISSION);
            }
            if (!(object instanceof DHParameterSpec) && !(object instanceof DHParameterSpec[]) && object != null) {
                throw new IllegalArgumentException("not a valid DHParameterSpec");
            }
            Object object2 = object;
            if (object2 == null) {
                this.dhThreadSpec.remove();
            } else {
                this.dhThreadSpec.set(object2);
            }
        } else if (string.equals("DhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_PERMISSION);
            }
            if (object instanceof DHParameterSpec || object instanceof DHParameterSpec[] || object == null) {
                this.dhDefaultParams = object;
            } else {
                throw new IllegalArgumentException("not a valid DHParameterSpec or DHParameterSpec[]");
            }
        }
    }

    public ECParameterSpec getEcImplicitlyCa() {
        ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecThreadSpec.get();
        if (eCParameterSpec != null) {
            return eCParameterSpec;
        }
        return this.ecImplicitCaParams;
    }

    public DHParameterSpec getDHDefaultParameters(int n) {
        Object object = this.dhThreadSpec.get();
        if (object == null) {
            object = this.dhDefaultParams;
        }
        if (object instanceof DHParameterSpec) {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)object;
            if (dHParameterSpec.getP().bitLength() == n) {
                return dHParameterSpec;
            }
        } else if (object instanceof DHParameterSpec[]) {
            DHParameterSpec[] dHParameterSpecArray = (DHParameterSpec[])object;
            for (int i = 0; i != dHParameterSpecArray.length; ++i) {
                if (dHParameterSpecArray[i].getP().bitLength() != n) continue;
                return dHParameterSpecArray[i];
            }
        }
        return null;
    }
}

