/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.types.selectors;

import com.github.dockerjava.shaded.org.apache.tools.ant.AntClassLoader;
import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.Project;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Parameter;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Path;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Reference;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.selectors.BaseSelector;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.selectors.ExtendFileSelector;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.selectors.FileSelector;
import java.io.File;
import java.util.Vector;

public class ExtendSelector
extends BaseSelector {
    private String classname = null;
    private FileSelector dynselector = null;
    private Vector<Parameter> paramVec = new Vector();
    private Path classpath = null;

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void selectorCreate() {
        if (this.classname != null && this.classname.length() > 0) {
            try {
                Class<?> c = null;
                if (this.classpath == null) {
                    c = Class.forName(this.classname);
                } else {
                    AntClassLoader al = this.getProject().createClassLoader(this.classpath);
                    c = Class.forName(this.classname, true, al);
                }
                this.dynselector = c.asSubclass(FileSelector.class).newInstance();
                Project p = this.getProject();
                if (p != null) {
                    p.setProjectReference(this.dynselector);
                }
            }
            catch (ClassNotFoundException cnfexcept) {
                this.setError("Selector " + this.classname + " not initialized, no such class");
            }
            catch (InstantiationException iexcept) {
                this.setError("Selector " + this.classname + " not initialized, could not create class");
            }
            catch (IllegalAccessException iaexcept) {
                this.setError("Selector " + this.classname + " not initialized, class not accessible");
            }
        } else {
            this.setError("There is no classname specified");
        }
    }

    public void addParam(Parameter p) {
        this.paramVec.addElement(p);
    }

    public final void setClasspath(Path classpath) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public final Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public final Path getClasspath() {
        return this.classpath;
    }

    public void setClasspathref(Reference r) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(r);
    }

    public void verifySettings() {
        if (this.dynselector == null) {
            this.selectorCreate();
        }
        if (this.classname == null || this.classname.length() < 1) {
            this.setError("The classname attribute is required");
        } else if (this.dynselector == null) {
            this.setError("Internal Error: The custom selector was not created");
        } else if (!(this.dynselector instanceof ExtendFileSelector) && this.paramVec.size() > 0) {
            this.setError("Cannot set parameters on custom selector that does not implement ExtendFileSelector");
        }
    }

    public boolean isSelected(File basedir, String filename, File file) throws BuildException {
        this.validate();
        if (this.paramVec.size() > 0 && this.dynselector instanceof ExtendFileSelector) {
            Object[] paramArray = new Parameter[this.paramVec.size()];
            this.paramVec.copyInto(paramArray);
            ((ExtendFileSelector)this.dynselector).setParameters((Parameter[])paramArray);
        }
        return this.dynselector.isSelected(basedir, filename, file);
    }
}

