/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.types;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.Project;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.DataType;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.EnumeratedAttribute;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Path;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Reference;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.CompositeMapper;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.ContainerMapper;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.FileNameMapper;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapper
extends DataType
implements Cloneable {
    protected MapperType type = null;
    protected String classname = null;
    protected Path classpath = null;
    protected String from = null;
    protected String to = null;
    private ContainerMapper container = null;

    public Mapper(Project p) {
        this.setProject(p);
    }

    public void setType(MapperType type) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.type = type;
    }

    public void addConfigured(FileNameMapper fileNameMapper) {
        this.add(fileNameMapper);
    }

    public void add(FileNameMapper fileNameMapper) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.container == null) {
            if (this.type == null && this.classname == null) {
                this.container = new CompositeMapper();
            } else {
                FileNameMapper m = this.getImplementation();
                if (m instanceof ContainerMapper) {
                    this.container = (ContainerMapper)m;
                } else {
                    throw new BuildException(String.valueOf(m) + " mapper implementation does not support nested mappers!");
                }
            }
        }
        this.container.add(fileNameMapper);
        this.setChecked(false);
    }

    public void addConfiguredMapper(Mapper mapper) {
        this.add(mapper.getImplementation());
    }

    public void setClassname(String classname) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.classname = classname;
    }

    public void setClasspath(Path classpath) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        this.setChecked(false);
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference ref) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(ref);
    }

    public void setFrom(String from) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.from = from;
    }

    public void setTo(String to) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.to = to;
    }

    @Override
    public void setRefid(Reference r) throws BuildException {
        if (this.type != null || this.from != null || this.to != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    public FileNameMapper getImplementation() throws BuildException {
        if (this.isReference()) {
            this.dieOnCircularReference();
            Reference r = this.getRefid();
            Object o = r.getReferencedObject(this.getProject());
            if (o instanceof FileNameMapper) {
                return (FileNameMapper)o;
            }
            if (o instanceof Mapper) {
                return ((Mapper)o).getImplementation();
            }
            String od = o == null ? "null" : o.getClass().getName();
            throw new BuildException(od + " at reference '" + r.getRefId() + "' is not a valid mapper reference.");
        }
        if (this.type == null && this.classname == null && this.container == null) {
            throw new BuildException("nested mapper or one of the attributes type or classname is required");
        }
        if (this.container != null) {
            return this.container;
        }
        if (this.type != null && this.classname != null) {
            throw new BuildException("must not specify both type and classname attribute");
        }
        try {
            FileNameMapper m = this.getImplementationClass().newInstance();
            Project p = this.getProject();
            if (p != null) {
                p.setProjectReference(m);
            }
            m.setFrom(this.from);
            m.setTo(this.to);
            return m;
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }

    protected Class<? extends FileNameMapper> getImplementationClass() throws ClassNotFoundException {
        String cName = this.classname;
        if (this.type != null) {
            cName = this.type.getImplementation();
        }
        ClassLoader loader = this.classpath == null ? this.getClass().getClassLoader() : this.getProject().createClassLoader(this.classpath);
        return Class.forName(cName, true, loader).asSubclass(FileNameMapper.class);
    }

    protected Mapper getRef() {
        return this.getCheckedRef(Mapper.class, this.getDataTypeName());
    }

    public static class MapperType
    extends EnumeratedAttribute {
        private Properties implementations = new Properties();

        public MapperType() {
            this.implementations.put("identity", "com.github.dockerjava.shaded.org.apache.tools.ant.util.IdentityMapper");
            this.implementations.put("flatten", "com.github.dockerjava.shaded.org.apache.tools.ant.util.FlatFileNameMapper");
            this.implementations.put("glob", "com.github.dockerjava.shaded.org.apache.tools.ant.util.GlobPatternMapper");
            this.implementations.put("merge", "com.github.dockerjava.shaded.org.apache.tools.ant.util.MergingMapper");
            this.implementations.put("regexp", "com.github.dockerjava.shaded.org.apache.tools.ant.util.RegexpPatternMapper");
            this.implementations.put("package", "com.github.dockerjava.shaded.org.apache.tools.ant.util.PackageNameMapper");
            this.implementations.put("unpackage", "com.github.dockerjava.shaded.org.apache.tools.ant.util.UnPackageNameMapper");
        }

        public String[] getValues() {
            return new String[]{"identity", "flatten", "glob", "merge", "regexp", "package", "unpackage"};
        }

        public String getImplementation() {
            return this.implementations.getProperty(this.getValue());
        }
    }
}

