/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.rmic;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.Project;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.Execute;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.LogStreamHandler;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.Rmic;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.rmic.DefaultRmicAdapter;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Commandline;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.JavaEnvUtils;
import java.io.IOException;

public class ForkingSunRmic
extends DefaultRmicAdapter {
    public static final String COMPILER_NAME = "forking";

    public boolean execute() throws BuildException {
        Rmic owner = this.getRmic();
        Commandline cmd = this.setupRmicCommand();
        Project project = owner.getProject();
        String executable = owner.getExecutable();
        if (executable == null) {
            executable = JavaEnvUtils.getJdkExecutable(this.getExecutableName());
        }
        cmd.setExecutable(executable);
        String[] args = cmd.getCommandline();
        try {
            Execute exe = new Execute(new LogStreamHandler(owner, 2, 1));
            exe.setAntRun(project);
            exe.setWorkingDirectory(project.getBaseDir());
            exe.setCommandline(args);
            exe.execute();
            return !exe.isFailure();
        }
        catch (IOException exception) {
            throw new BuildException("Error running " + this.getExecutableName() + " -maybe it is not on the path", exception);
        }
    }

    protected String getExecutableName() {
        return "rmic";
    }
}

