/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.native2ascii;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.ProjectComponent;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.Native2Ascii;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.native2ascii.DefaultNative2Ascii;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Commandline;
import java.lang.reflect.Method;

public final class SunNative2Ascii
extends DefaultNative2Ascii {
    public static final String IMPLEMENTATION_NAME = "sun";

    protected void setup(Commandline cmd, Native2Ascii args) throws BuildException {
        if (args.getReverse()) {
            cmd.createArgument().setValue("-reverse");
        }
        super.setup(cmd, args);
    }

    protected boolean run(Commandline cmd, ProjectComponent log) throws BuildException {
        try {
            Class<?> n2aMain = Class.forName("sun.tools.native2ascii.Main");
            Class[] param = new Class[]{String[].class};
            Method convert = n2aMain.getMethod("convert", param);
            if (convert == null) {
                throw new BuildException("Could not find convert() method in sun.tools.native2ascii.Main");
            }
            Object o = n2aMain.newInstance();
            return (Boolean)convert.invoke(o, new Object[]{cmd.getArguments()});
        }
        catch (BuildException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BuildException("Error starting Sun's native2ascii: ", ex);
        }
    }
}

