/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.com.google.common.io;

import com.github.dockerjava.shaded.com.google.common.annotations.Beta;
import com.github.dockerjava.shaded.com.google.common.base.Preconditions;
import com.github.dockerjava.shaded.javax.annotation.Nullable;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

@Beta
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    @Override
    public boolean accept(@Nullable File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

