/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.operator.bc;

import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.InvalidCipherTextException;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.Wrapper;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.KeyParameter;
import com.github.dockerjava.shaded.org.bouncycastle.operator.GenericKey;
import com.github.dockerjava.shaded.org.bouncycastle.operator.OperatorException;
import com.github.dockerjava.shaded.org.bouncycastle.operator.SymmetricKeyUnwrapper;
import java.security.SecureRandom;

public class BcSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, Wrapper wrapper, KeyParameter keyParameter) {
        super(algorithmIdentifier);
        this.wrapper = wrapper;
        this.wrappingKey = keyParameter;
    }

    public BcSymmetricKeyUnwrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws OperatorException {
        this.wrapper.init(false, this.wrappingKey);
        try {
            return new GenericKey(algorithmIdentifier, this.wrapper.unwrap(byArray, 0, byArray.length));
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new OperatorException("unable to unwrap key: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }
}

