/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.cms;

import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.cert.X509CertificateHolder;
import com.github.dockerjava.shaded.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import com.github.dockerjava.shaded.org.bouncycastle.operator.ContentVerifier;
import com.github.dockerjava.shaded.org.bouncycastle.operator.ContentVerifierProvider;
import com.github.dockerjava.shaded.org.bouncycastle.operator.DigestCalculator;
import com.github.dockerjava.shaded.org.bouncycastle.operator.DigestCalculatorProvider;
import com.github.dockerjava.shaded.org.bouncycastle.operator.OperatorCreationException;
import com.github.dockerjava.shaded.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;

public class SignerInformationVerifier {
    private ContentVerifierProvider verifierProvider;
    private DigestCalculatorProvider digestProvider;
    private SignatureAlgorithmIdentifierFinder sigAlgorithmFinder;
    private CMSSignatureAlgorithmNameGenerator sigNameGenerator;

    public SignerInformationVerifier(CMSSignatureAlgorithmNameGenerator cMSSignatureAlgorithmNameGenerator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder, ContentVerifierProvider contentVerifierProvider, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigNameGenerator = cMSSignatureAlgorithmNameGenerator;
        this.sigAlgorithmFinder = signatureAlgorithmIdentifierFinder;
        this.verifierProvider = contentVerifierProvider;
        this.digestProvider = digestCalculatorProvider;
    }

    public boolean hasAssociatedCertificate() {
        return this.verifierProvider.hasAssociatedCertificate();
    }

    public X509CertificateHolder getAssociatedCertificate() {
        return this.verifierProvider.getAssociatedCertificate();
    }

    public ContentVerifier getContentVerifier(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) throws OperatorCreationException {
        String string = this.sigNameGenerator.getSignatureName(algorithmIdentifier2, algorithmIdentifier);
        return this.verifierProvider.get(this.sigAlgorithmFinder.find(string));
    }

    public DigestCalculator getDigestCalculator(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        return this.digestProvider.get(algorithmIdentifier);
    }
}

