/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.io.netty.handler.codec.protobuf;

import com.github.dockerjava.shaded.com.google.protobuf.nano.MessageNano;
import com.github.dockerjava.shaded.io.netty.buffer.ByteBuf;
import com.github.dockerjava.shaded.io.netty.channel.ChannelHandler;
import com.github.dockerjava.shaded.io.netty.channel.ChannelHandlerContext;
import com.github.dockerjava.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import com.github.dockerjava.shaded.io.netty.util.internal.ObjectUtil;
import java.util.List;

@ChannelHandler.Sharable
public class ProtobufDecoderNano
extends MessageToMessageDecoder<ByteBuf> {
    private final Class<? extends MessageNano> clazz;

    public ProtobufDecoderNano(Class<? extends MessageNano> clazz) {
        this.clazz = ObjectUtil.checkNotNull(clazz, "You must provide a Class");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int offset;
        byte[] array;
        int length = msg.readableBytes();
        if (msg.hasArray()) {
            array = msg.array();
            offset = msg.arrayOffset() + msg.readerIndex();
        } else {
            array = new byte[length];
            msg.getBytes(msg.readerIndex(), array, 0, length);
            offset = 0;
        }
        MessageNano prototype = this.clazz.newInstance();
        out.add(MessageNano.mergeFrom((MessageNano)prototype, (byte[])array, (int)offset, (int)length));
    }
}

