/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.text.TextUtils;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.WeakHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLContextUtil {
    private static final String TAG = "SSLContextUtil";
    private static Map<String, SSLContext> SSL_CACHE = new WeakHashMap<String, SSLContext>();
    private static TrustManager trustManagers = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };
    public static final HostnameVerifier HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static SSLContext getSSLContextFromAssets(String caAlias, String caPath, String protocol) {
        if (TextUtils.isEmpty((CharSequence)caAlias) || TextUtils.isEmpty((CharSequence)caPath)) {
            return null;
        }
        try {
            String cacheKey = SSLContextUtil.getCacheKey(caAlias, caPath);
            SSLContext sslContext = SSL_CACHE.get(cacheKey);
            if (sslContext != null) {
                return sslContext;
            }
            InputStream caInput = AriaConfig.getInstance().getAPP().getAssets().open(caPath);
            Certificate ca = SSLContextUtil.loadCert(caInput);
            return SSLContextUtil.createContext(caAlias, ca, protocol, cacheKey);
        }
        catch (IOException | CertificateException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SSLContext getSSLContext(String caAlias, String caPath, String protocol) {
        if (TextUtils.isEmpty((CharSequence)caAlias) || TextUtils.isEmpty((CharSequence)caPath)) {
            return null;
        }
        try {
            String cacheKey = SSLContextUtil.getCacheKey(caAlias, caPath);
            SSLContext sslContext = SSL_CACHE.get(cacheKey);
            if (sslContext != null) {
                return sslContext;
            }
            Certificate ca = SSLContextUtil.loadCert(new FileInputStream(caPath));
            return SSLContextUtil.createContext(caAlias, ca, protocol, cacheKey);
        }
        catch (IOException | CertificateException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SSLContext createContext(String caAlias, Certificate ca, String protocol, String cacheKey) {
        try {
            String keyStoreType = KeyStore.getDefaultType();
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(null, null);
            keyStore.setCertificateEntry(caAlias, ca);
            String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
            tmf.init(keyStore);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, null);
            SSLContext context = SSLContext.getInstance(TextUtils.isEmpty((CharSequence)protocol) ? "TLS" : protocol);
            context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
            SSL_CACHE.put(cacheKey, context);
            return context;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getCacheKey(String alias, String path) {
        return CommonUtil.getStrMd5(String.format("%s_%s", alias, path));
    }

    private static Certificate loadCert(InputStream is) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate ca = cf.generateCertificate(is);
        ALog.d(TAG, String.format("ca\u3010%s\u3011", ((X509Certificate)ca).getSubjectDN()));
        is.close();
        return ca;
    }

    public static SSLContext getDefaultSLLContext(String protocol) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance(TextUtils.isEmpty((CharSequence)protocol) ? "TLS" : protocol);
            sslContext.init(null, new TrustManager[]{trustManagers}, new SecureRandom());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sslContext;
    }
}

