/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.text.TextUtils;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsNormalEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.DbDataHelper;
import com.arialyy.aria.util.DeleteDGRecord;
import com.arialyy.aria.util.DeleteDRecord;
import com.arialyy.aria.util.DeleteM3u8Record;
import com.arialyy.aria.util.DeleteURecord;
import java.io.File;

public class RecordUtil {
    private static final String TAG = "RecordUtil";

    public static void delGroupTaskRecordByHash(String groupHash, boolean removeFile) {
        if (TextUtils.isEmpty((CharSequence)groupHash)) {
            ALog.e(TAG, "\u5220\u9664\u4e0b\u8f7d\u4efb\u52a1\u7ec4\u8bb0\u5f55\u5931\u8d25\uff0cgroupHash\u4e3anull");
            return;
        }
        DownloadGroupEntity groupEntity = DbDataHelper.getDGEntityByHash(groupHash);
        DeleteDGRecord.getInstance().deleteRecord(groupEntity, removeFile, true);
    }

    public static void delNormalTaskRecord(AbsNormalEntity entity, boolean removeFile) {
        switch (entity.getTaskType()) {
            case 1: 
            case 3: 
            case 9: 
            case 12: {
                DeleteDRecord.getInstance().deleteRecord(entity, removeFile, true);
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                DeleteURecord.getInstance().deleteRecord(entity, removeFile, true);
                break;
            }
            case 7: 
            case 8: {
                DeleteM3u8Record.getInstance().deleteRecord(entity, removeFile, true);
            }
        }
    }

    public static void delTaskRecord(String filePath, int type, boolean removeFile, boolean removeEntity) {
        switch (type) {
            case 1: 
            case 3: 
            case 9: 
            case 12: {
                DeleteDRecord.getInstance().deleteRecord(filePath, removeFile, removeEntity);
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                DeleteURecord.getInstance().deleteRecord(filePath, removeFile, removeEntity);
                break;
            }
            case 7: 
            case 8: {
                DeleteM3u8Record.getInstance().deleteRecord(filePath, removeFile, removeEntity);
            }
        }
    }

    public static void modifyTaskRecord(String oldPath, String newPath, int taskType) {
        File oldFile;
        if (oldPath.equals(newPath)) {
            ALog.w(TAG, "\u4fee\u6539\u4efb\u52a1\u8bb0\u5f55\u5931\u8d25\uff0c\u65b0\u6587\u4ef6\u8def\u5f84\u548c\u65e7\u6587\u4ef6\u8def\u5f84\u4e00\u81f4");
            return;
        }
        TaskRecord record = DbDataHelper.getTaskRecord(oldPath, taskType);
        if (record == null) {
            if (new File(oldPath).exists()) {
                ALog.w(TAG, "\u4fee\u6539\u4efb\u52a1\u8bb0\u5f55\u5931\u8d25\uff0c\u6587\u4ef6\u3010" + oldPath + "\u3011\u5bf9\u5e94\u7684\u4efb\u52a1\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            return;
        }
        if (!record.isBlock && (oldFile = new File(oldPath)).exists()) {
            oldFile.renameTo(new File(newPath));
        }
        record.filePath = newPath;
        record.update();
        if (record.threadRecords != null && !record.threadRecords.isEmpty()) {
            for (ThreadRecord tr : record.threadRecords) {
                tr.taskKey = newPath;
                File blockFile = new File(String.format("%s.%s.part", oldPath, tr.threadId));
                if (!blockFile.exists()) continue;
                blockFile.renameTo(new File(String.format("%s.%s.part", newPath, tr.threadId)));
            }
            DbEntity.updateManyData(record.threadRecords);
        }
    }

    public static boolean blockTaskExists(String filePath) {
        return new File(String.format("%s.%s.part", filePath, 0)).exists();
    }

    public static long getBlockLen(long fileLen, int blockId, int blockNum) {
        long averageLen = fileLen / (long)blockNum;
        return blockId == blockNum - 1 ? fileLen - (long)blockId * averageLen : averageLen;
    }
}

