/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.arialyy.aria.core.AriaConfig;

public class NetUtils {
    public static final int NETWORK_TYPE_INVALID = 0;
    public static final int NETWORK_TYPE_WAP = 1;
    public static final int NETWORK_TYPE_2G = 2;
    public static final int NETWORK_TYPE_3G = 3;
    public static final int NETWORK_TYPE_WIFI = 4;

    public static boolean isConnected(Context context) {
        if (!AriaConfig.getInstance().getAConfig().isNetCheck()) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return AriaConfig.getInstance().isConnectedNet();
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni != null && ni.isConnectedOrConnecting();
    }

    public static boolean isWifi(Context context) {
        return NetUtils.getNetWorkType(context) == 4;
    }

    public static int getNetWorkType(Context context) {
        int netWorkType = -1;
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            String type = networkInfo.getTypeName();
            if (type.equalsIgnoreCase("WIFI")) {
                netWorkType = 4;
            } else if (type.equalsIgnoreCase("MOBILE")) {
                String proxyHost = Proxy.getDefaultHost();
                netWorkType = TextUtils.isEmpty((CharSequence)proxyHost) ? (NetUtils.isFastMobileNetwork(context) ? 3 : 2) : 1;
            }
        } else {
            netWorkType = 0;
        }
        return netWorkType;
    }

    private static boolean isFastMobileNetwork(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        switch (telephonyManager.getNetworkType()) {
            case 7: {
                return false;
            }
            case 4: {
                return false;
            }
            case 2: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 1: {
                return false;
            }
            case 8: {
                return true;
            }
            case 10: {
                return true;
            }
            case 9: {
                return true;
            }
            case 3: {
                return true;
            }
            case 14: {
                return true;
            }
            case 12: {
                return true;
            }
            case 15: {
                return true;
            }
            case 11: {
                return false;
            }
            case 13: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }
}

