/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.text.TextUtils;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Pattern;

public class FileUtil {
    private static final String TAG = "FileUtil";
    private static final Pattern DIR_SEPORATOR = Pattern.compile("/");
    private static final String EXTERNAL_STORAGE_PATH = Environment.getExternalStorageDirectory().getPath();

    public static String getFileExtensionName(String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        int endP = fileName.lastIndexOf(".");
        return endP > -1 ? fileName.substring(endP + 1) : null;
    }

    public static void createFileFormInputStream(InputStream is, String dest) {
        try {
            int len;
            FileOutputStream fos = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
            is.close();
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getTsCacheDir(String path, int bandWidth) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            throw new NullPointerException("m3u8\u6587\u4fdd\u5b58\u8def\u5f84\u4e3a\u7a7a");
        }
        File file = new File(path);
        return String.format("%s/.%s_%s", file.getParent(), file.getName(), bandWidth);
    }

    public static boolean createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            if (!file.mkdirs()) {
                ALog.d(TAG, "\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u548c\u662f\u5426\u914d\u7f6e\u6587\u4ef6\u6743\u9650\uff01");
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean createFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            ALog.e(TAG, "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3anull");
            return false;
        }
        return FileUtil.createFile(new File(path));
    }

    public static boolean createFile(File file) {
        if (file.getParentFile() == null || !file.getParentFile().exists()) {
            ALog.d(TAG, "\u76ee\u6807\u6587\u4ef6\u6240\u5728\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u521b\u5efa\u2026\u2026");
            if (!FileUtil.createDir(file.getParent())) {
                ALog.d(TAG, "\u521b\u5efa\u76ee\u5f55\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25\uff01\u6587\u4ef6\u8def\u5f84\u3010" + file.getPath() + "\u3011");
            }
        }
        FileUtil.deleteFile(file);
        try {
            if (file.createNewFile()) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static String createFileName(String url) {
        int end = url.indexOf("?");
        String fileName = "";
        if (end > 0) {
            String tempUrl = url.substring(0, end);
            int tempEnd = tempUrl.lastIndexOf("/");
            if (tempEnd > 0) {
                fileName = tempUrl.substring(tempEnd + 1);
            }
        } else {
            int tempEnd = url.lastIndexOf("/");
            if (tempEnd > 0) {
                fileName = url.substring(tempEnd + 1);
            }
        }
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            fileName = CommonUtil.keyToHashKey(url);
        }
        return fileName;
    }

    public static boolean deleteFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            ALog.e(TAG, "\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff0c\u8def\u5f84\u4e3a\u7a7a");
            return false;
        }
        return FileUtil.deleteFile(new File(path));
    }

    public static boolean deleteFile(File file) {
        if (file.exists()) {
            File to = new File(file.getAbsolutePath() + System.currentTimeMillis());
            if (file.renameTo(to)) {
                return to.delete();
            }
            return file.delete();
        }
        return false;
    }

    public static boolean deleteDir(File dirFile) {
        if (!dirFile.exists()) {
            return false;
        }
        if (dirFile.isFile()) {
            return dirFile.delete();
        }
        for (File file : dirFile.listFiles()) {
            FileUtil.deleteDir(file);
        }
        return dirFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjToFile(String filePath, Object data) {
        if (!(data instanceof Serializable)) {
            ALog.e(TAG, "\u5bf9\u8c61\u5199\u5165\u6587\u4ef6\u5931\u8d25\uff0cdata\u6570\u636e\u5fc5\u987b\u5b9e\u73b0Serializable\u63a5\u53e3");
            return;
        }
        FileOutputStream ops = null;
        try {
            if (!FileUtil.createFile(filePath)) {
                return;
            }
            ops = new FileOutputStream(filePath);
            ObjectOutputStream oops = new ObjectOutputStream(ops);
            oops.writeObject(data);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (ops != null) {
                try {
                    ops.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjFromFile(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            ALog.e(TAG, "\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            ALog.e(TAG, String.format("\u6587\u4ef6\u3010%s\u3011\u4e0d\u5b58\u5728", filePath));
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            ObjectInputStream oois = new ObjectInputStream(fis);
            Object object = oois.readObject();
            return object;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mergeFile(String targetPath, List<String> subPaths) {
        File file = new File(targetPath);
        FileOutputStream fos = null;
        AbstractInterruptibleChannel foc = null;
        long startTime = System.currentTimeMillis();
        try {
            if (file.exists() && file.isDirectory()) {
                ALog.w(TAG, String.format("\u8def\u5f84\u3010%s\u3011\u662f\u6587\u4ef6\u5939\uff0c\u5c06\u5220\u9664\u8be5\u6587\u4ef6\u5939", targetPath));
                FileUtil.deleteDir(file);
            }
            if (!file.exists()) {
                FileUtil.createFile(file);
            }
            fos = new FileOutputStream(targetPath);
            foc = fos.getChannel();
            LinkedList streams = new LinkedList();
            long fileLen = 0L;
            for (String subPath : subPaths) {
                File f = new File(subPath);
                if (!f.exists()) {
                    ALog.d(TAG, String.format("\u5408\u5e76\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u3010%s\u3011\u4e0d\u5b58\u5728", subPath));
                    for (FileInputStream fis : streams) {
                        fis.close();
                    }
                    streams.clear();
                    boolean bl = false;
                    return bl;
                }
                FileInputStream fis = new FileInputStream(subPath);
                FileChannel fic = fis.getChannel();
                ((FileChannel)foc).transferFrom(fic, fileLen, f.length());
                fileLen += f.length();
                fis.close();
            }
            ALog.d(TAG, String.format("\u5408\u5e76\u6587\u4ef6\u8017\u65f6\uff1a%sms", System.currentTimeMillis() - startTime));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (foc != null) {
                    foc.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mergeSFtpFile(String targetPath, List<String> subPaths, long targetFileSize) {
        File file = new File(targetPath);
        FileOutputStream fos = null;
        AbstractInterruptibleChannel foc = null;
        long startTime = System.currentTimeMillis();
        try {
            if (file.exists() && file.isDirectory()) {
                ALog.w(TAG, String.format("\u8def\u5f84\u3010%s\u3011\u662f\u6587\u4ef6\u5939\uff0c\u5c06\u5220\u9664\u8be5\u6587\u4ef6\u5939", targetPath));
                FileUtil.deleteDir(file);
            }
            if (!file.exists()) {
                FileUtil.createFile(file);
            }
            fos = new FileOutputStream(targetPath);
            foc = fos.getChannel();
            LinkedList streams = new LinkedList();
            int i = 0;
            int threadNum = subPaths.size();
            long tempLen = targetFileSize / (long)threadNum;
            for (String subPath : subPaths) {
                File f = new File(subPath);
                if (!f.exists()) {
                    ALog.d(TAG, String.format("\u5408\u5e76\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u3010%s\u3011\u4e0d\u5b58\u5728", subPath));
                    for (FileInputStream fis : streams) {
                        fis.close();
                    }
                    streams.clear();
                    boolean bl = false;
                    return bl;
                }
                long blockLen = i == threadNum - 1 ? targetFileSize - tempLen * (long)i : tempLen;
                FileInputStream fis = new FileInputStream(subPath);
                FileChannel fic = fis.getChannel();
                ((FileChannel)foc).transferFrom(fic, blockLen * (long)i, blockLen);
                fis.close();
                ++i;
            }
            ALog.d(TAG, String.format("\u5408\u5e76\u6587\u4ef6\u8017\u65f6\uff1a%sms\uff0c\u5408\u5e76\u540e\u7684\u6587\u4ef6\u957f\u5ea6\uff1a%s", System.currentTimeMillis() - startTime, file.length()));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (foc != null) {
                    foc.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void splitFile(String filePath, int num) {
        try {
            File file = new File(filePath);
            long size = file.length();
            FileInputStream fis = new FileInputStream(file);
            FileChannel fic = fis.getChannel();
            long j = 0L;
            long block = size / (long)num;
            for (int i = 0; i < num; ++i) {
                int len;
                if (i == num - 1) {
                    block = size - block * (long)(num - 1);
                }
                String subPath = file.getPath() + "." + i + ".part";
                ALog.d(TAG, String.format("block = %s", block));
                File subFile = new File(subPath);
                if (!subFile.exists()) {
                    FileUtil.createFile(subFile);
                }
                FileOutputStream fos = new FileOutputStream(subFile);
                FileChannel sfoc = fos.getChannel();
                ByteBuffer bf = ByteBuffer.allocate(8196);
                while ((len = fic.read(bf)) != -1) {
                    bf.flip();
                    sfoc.write(bf);
                    bf.compact();
                    if ((j += (long)len) < block * (long)(i + 1)) continue;
                }
                ALog.d(TAG, String.format("len = %s", subFile.length()));
                fos.close();
                sfoc.close();
            }
            fis.close();
            fic.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkMemorySpace(String path, long fileSize) {
        File temp = new File(path);
        if (!temp.exists()) {
            if (!temp.getParentFile().exists()) {
                FileUtil.createDir(temp.getParentFile().getPath());
            }
            path = temp.getParentFile().getPath();
        }
        StatFs stat = new StatFs(path);
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return fileSize <= availableBlocks * blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadConfig(File file) {
        Properties properties = new Properties();
        FileInputStream fis = null;
        if (!file.exists()) {
            FileUtil.createFile(file.getPath());
        }
        try {
            fis = new FileInputStream(file);
            properties.load(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfig(File file, Properties properties) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, false);
            properties.store(fos, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.flush();
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    private static boolean checkSDMemorySpace(String filePath, long fileSize) {
        List<String> dirs = FileUtil.getSDPathList(AriaConfig.getInstance().getAPP());
        if (dirs == null || dirs.isEmpty()) {
            return true;
        }
        for (String path : dirs) {
            if (!filePath.contains(path) || fileSize <= 0L || fileSize <= FileUtil.getAvailableExternalMemorySize(path)) continue;
            return false;
        }
        return true;
    }

    private static long getAvailableExternalMemorySize(String sdcardPath) {
        StatFs stat = new StatFs(sdcardPath);
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }

    private static long getTotalExternalMemorySize(String sdcardPath) {
        StatFs stat = new StatFs(sdcardPath);
        long blockSize = stat.getBlockSize();
        long totalBlocks = stat.getBlockCount();
        return totalBlocks * blockSize;
    }

    private static List<String> getSDPathList(Context context) {
        List<String> paths = null;
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                paths = FileUtil.getVolumeList(context);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            List<String> mounts = FileUtil.readMountsFile();
            List<String> volds = FileUtil.readVoldFile();
            paths = FileUtil.compareMountsWithVold(mounts, volds);
        }
        return paths;
    }

    private static List<String> getVolumeList(Context context) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ArrayList<String> pathList = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 24) {
            StorageManager manager = (StorageManager)context.getSystemService("storage");
            List volumes = manager.getStorageVolumes();
            Class<StorageVolume> volumeClass = StorageVolume.class;
            Method getPath = volumeClass.getDeclaredMethod("getPath", new Class[0]);
            getPath.setAccessible(true);
            Iterator iterator = volumes.iterator();
            while (iterator.hasNext()) {
                StorageVolume volume = (StorageVolume)iterator.next();
                String state = volume.getState();
                if (!state.equals("mounted")) continue;
                pathList.add((String)getPath.invoke((Object)volume, new Object[0]));
            }
        } else {
            pathList.addAll(FileUtil.getStorageDirectories());
        }
        if (pathList.isEmpty()) {
            pathList = new ArrayList();
            pathList.add(EXTERNAL_STORAGE_PATH);
        }
        LinkedHashMap<Integer, String> paths = new LinkedHashMap<Integer, String>();
        for (String path : pathList) {
            int key;
            String prevPath;
            File root = new File(path);
            if (!root.exists() || !root.isDirectory() || !FileUtil.canWrite(path) || !TextUtils.isEmpty((CharSequence)(prevPath = (String)paths.get(key = (root.getTotalSpace() + "-" + root.getUsableSpace()).hashCode()))) && prevPath.length() < path.length()) continue;
            paths.put(key, path);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Integer key : paths.keySet()) {
            list.add((String)paths.get(key));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(String dirPath) {
        boolean canWrite;
        File dir = new File(dirPath);
        if (dir.canWrite()) {
            return true;
        }
        File testWriteFile = null;
        try {
            testWriteFile = new File(dirPath, "tw.txt");
            if (testWriteFile.exists()) {
                testWriteFile.delete();
            }
            testWriteFile.createNewFile();
            FileWriter writer = new FileWriter(testWriteFile);
            writer.write(1);
            writer.close();
            canWrite = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            canWrite = false;
        }
        finally {
            try {
                if (testWriteFile != null && testWriteFile.exists()) {
                    testWriteFile.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return canWrite;
    }

    private static List<String> getStorageDirectories() {
        String path;
        ArrayList<String> rv = new ArrayList<String>();
        String rawExternalStorage = System.getenv("EXTERNAL_STORAGE");
        String rawSecondaryStoragesStr = System.getenv("SECONDARY_STORAGE");
        String rawEmulatedStorageTarget = System.getenv("EMULATED_STORAGE_TARGET");
        if (TextUtils.isEmpty((CharSequence)rawEmulatedStorageTarget)) {
            if (TextUtils.isEmpty((CharSequence)rawExternalStorage)) {
                rv.add("/storage/sdcard0");
            } else {
                rv.add(rawExternalStorage);
            }
        } else {
            String rawUserId;
            path = Environment.getExternalStorageDirectory().getAbsolutePath();
            String[] folders = DIR_SEPORATOR.split(path);
            String lastFolder = folders[folders.length - 1];
            boolean isDigit = false;
            if (!TextUtils.isEmpty((CharSequence)lastFolder) && TextUtils.isDigitsOnly((CharSequence)lastFolder)) {
                isDigit = true;
            }
            String string = rawUserId = isDigit ? lastFolder : "";
            if (TextUtils.isEmpty((CharSequence)rawUserId)) {
                rv.add(rawExternalStorage);
            } else {
                rv.add(rawEmulatedStorageTarget + File.separator + rawUserId);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)rawSecondaryStoragesStr)) {
            String[] rawSecondaryStorages = rawSecondaryStoragesStr.split(File.pathSeparator);
            Collections.addAll(rv, rawSecondaryStorages);
        }
        for (int i = rv.size() - 1; i >= 0; --i) {
            path = (String)rv.get(i);
            File root = new File(path);
            if (root.exists() && root.isDirectory() && FileUtil.canWrite(path)) continue;
            rv.remove(i);
        }
        return rv;
    }

    private static List<String> readMountsFile() {
        ArrayList<String> mounts = new ArrayList<String>();
        mounts.add(EXTERNAL_STORAGE_PATH);
        try {
            Scanner scanner = new Scanner(new File("/proc/mounts"));
            while (scanner.hasNext()) {
                String[] lineElements;
                String element;
                String line = scanner.nextLine();
                if (!line.startsWith("/dev/block/vold/") && !line.startsWith("/dev/block//vold/") || (element = (lineElements = line.split(" "))[1]).equals(EXTERNAL_STORAGE_PATH)) continue;
                mounts.add(element);
            }
            scanner.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mounts;
    }

    private static List<String> readVoldFile() {
        ArrayList<String> vold = null;
        Scanner scanner = null;
        try {
            try {
                scanner = new Scanner(new File("/system/etc/vold.fstab"));
            }
            catch (FileNotFoundException e1) {
                scanner = new Scanner(new File("/system/etc/vold.conf"));
            }
            vold = new ArrayList<String>();
            vold.add(EXTERNAL_STORAGE_PATH);
            while (scanner.hasNext()) {
                String element;
                String line = scanner.nextLine();
                if (TextUtils.isEmpty((CharSequence)line)) continue;
                if ((line = line.trim()).startsWith("dev_mount")) {
                    String[] lineElements = line.split(" ");
                    if (lineElements.length < 3) continue;
                    String element2 = lineElements[2];
                    if (element2.contains(":")) {
                        element2 = element2.substring(0, element2.indexOf(":"));
                    }
                    if (element2.equals(EXTERNAL_STORAGE_PATH)) continue;
                    vold.add(element2);
                    continue;
                }
                if (!line.startsWith("mount_point") || (element = line.replaceAll("mount_point", "").trim()).equals(EXTERNAL_STORAGE_PATH)) continue;
                vold.add(element);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vold;
    }

    private static List<String> compareMountsWithVold(List<String> mounts, List<String> volds) {
        for (int i = mounts.size() - 1; i >= 0; --i) {
            String mount = mounts.get(i);
            File root = new File(mount);
            if (!(root.exists() && root.isDirectory() && root.canWrite())) {
                mounts.remove(i);
                continue;
            }
            if (volds == null || volds.contains(mount)) continue;
            mounts.remove(i);
        }
        if (volds != null) {
            volds.clear();
        }
        return mounts;
    }

    public static long getTotalMemory() {
        String file_path = "/proc/meminfo";
        long initial_memory = 0L;
        try {
            FileReader fr = new FileReader(file_path);
            BufferedReader localBufferedReader = new BufferedReader(fr, 8192);
            String ram_info = localBufferedReader.readLine();
            String[] arrayOfRam = ram_info.split("\\s+");
            initial_memory = Integer.valueOf(arrayOfRam[1]) * 1024;
            localBufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return initial_memory;
    }

    public static long getAvailMemory(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo.availMem;
    }
}

