/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.annotation.SuppressLint;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ErrorHelp {
    public static void saveError(String msg, String ex) {
        ErrorHelp.writeLogToFile(String.format("\nmsg\u3010%s\u3011\nException\uff1a%s", msg, ex));
    }

    private static String getLogPath() {
        String path = String.format("%slog/AriaCrash_%s.log", CommonUtil.getAppPath(AriaConfig.getInstance().getAPP()), ErrorHelp.getData("yyyy-MM-dd_HH_mm_ss"));
        FileUtil.createFile(path);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeLogToFile(String message) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ErrorHelp.getData("yyyy-MM-dd HH:mm:ss"));
        stringBuffer.append("    ");
        stringBuffer.append(message);
        stringBuffer.append("\n\n");
        try (PrintWriter writer = null;){
            File file = new File(ErrorHelp.getLogPath());
            if (!file.exists()) {
                FileUtil.createFile(file);
            }
            writer = new PrintWriter(new FileWriter(file.getPath(), true));
            writer.append(stringBuffer);
            writer.flush();
        }
        return 0;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private static String getData(String format) {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }
}

