/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.text.TextUtils;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import com.arialyy.aria.util.IDeleteRecord;

public class DeleteURecord
implements IDeleteRecord {
    private String TAG = CommonUtil.getClassName(this);
    private static volatile DeleteURecord INSTANCE = null;

    private DeleteURecord() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeleteURecord getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DeleteURecord> clazz = DeleteURecord.class;
        synchronized (DeleteURecord.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DeleteURecord();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public void deleteRecord(String filePath, boolean needRemoveFile, boolean needRemoveEntity) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            throw new NullPointerException("\u5220\u9664\u8bb0\u5f55\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (!filePath.startsWith("/")) {
            throw new IllegalArgumentException(String.format("\u6587\u4ef6\u8def\u5f84\u9519\u8bef\uff0cfilePath\uff1a%s", filePath));
        }
        UploadEntity entity = DbEntity.findFirst(UploadEntity.class, "filePath=?", filePath);
        if (entity == null) {
            ALog.e(this.TAG, "\u5220\u9664\u4e0a\u4f20\u8bb0\u5f55\u5931\u8d25\uff0c\u6ca1\u6709\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53\u6587\u4ef6\uff0cfilePath\uff1a" + filePath);
            return;
        }
        this.deleteRecord(entity, needRemoveFile, needRemoveEntity);
    }

    @Override
    public void deleteRecord(AbsEntity absEntity, boolean needRemoveFile, boolean needRemoveEntity) {
        if (absEntity == null) {
            ALog.e(this.TAG, "\u5220\u9664\u4e0a\u4f20\u8bb0\u5f55\u5931\u8d25\uff0c\u5b9e\u4f53\u4e3a\u7a7a");
            return;
        }
        UploadEntity entity = (UploadEntity)absEntity;
        DbEntity.deleteData(ThreadRecord.class, "taskKey=? AND threadType=?", entity.getFilePath(), String.valueOf(entity.getTaskType()));
        DbEntity.deleteData(TaskRecord.class, "filePath=? AND taskType=?", entity.getFilePath(), String.valueOf(entity.getTaskType()));
        if (needRemoveFile) {
            FileUtil.deleteFile(entity.getFilePath());
        }
        this.deleteEntity(needRemoveEntity, entity.getFilePath());
    }

    private void deleteEntity(boolean needRemoveEntity, String filePath) {
        if (needRemoveEntity) {
            DbEntity.deleteData(UploadEntity.class, "filePath=?", filePath);
        }
    }
}

