/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.text.TextUtils;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.DbDataHelper;
import com.arialyy.aria.util.DeleteM3u8Record;
import com.arialyy.aria.util.FileUtil;
import com.arialyy.aria.util.IDeleteRecord;
import java.io.File;

public class DeleteDRecord
implements IDeleteRecord {
    private String TAG = CommonUtil.getClassName(this);
    private static volatile DeleteDRecord INSTANCE = null;

    private DeleteDRecord() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeleteDRecord getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DeleteDRecord> clazz = DeleteDRecord.class;
        synchronized (DeleteDRecord.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DeleteDRecord();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public void deleteRecord(String filePath, boolean removeTarget, boolean needRemoveEntity) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            throw new NullPointerException("\u5220\u9664\u8bb0\u5f55\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (!filePath.startsWith("/")) {
            throw new IllegalArgumentException(String.format("\u6587\u4ef6\u8def\u5f84\u9519\u8bef\uff0cfilePath\uff1a%s", filePath));
        }
        DownloadEntity entity = DbEntity.findFirst(DownloadEntity.class, "downloadPath=?", filePath);
        if (entity == null) {
            ALog.e(this.TAG, "\u5220\u9664\u4e0b\u8f7d\u8bb0\u5f55\u5931\u8d25\uff0c\u6ca1\u6709\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53\u6587\u4ef6\uff0cfilePath\uff1a" + filePath);
            return;
        }
        this.deleteRecord(entity, removeTarget, needRemoveEntity);
    }

    @Override
    public void deleteRecord(AbsEntity absEntity, boolean needRemoveFile, boolean needRemoveEntity) {
        if (absEntity == null) {
            ALog.e(this.TAG, "\u5220\u9664\u4e0b\u8f7d\u8bb0\u5f55\u5931\u8d25\uff0c\u5b9e\u4f53\u4e3a\u7a7a");
            return;
        }
        DownloadEntity entity = (DownloadEntity)absEntity;
        String filePath = entity.getFilePath();
        File targetFile = new File(filePath);
        if (entity.getTaskType() == 7 || entity.getTaskType() == 8) {
            DeleteM3u8Record.getInstance().deleteRecord(entity, needRemoveFile, needRemoveEntity);
            return;
        }
        TaskRecord record = DbDataHelper.getTaskRecord(entity.getFilePath(), entity.getTaskType());
        if (record == null) {
            ALog.e(this.TAG, "\u5220\u9664\u4e0b\u8f7d\u8bb0\u5f55\u5931\u8d25\uff0c\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u5c06\u5220\u9664\u5b9e\u4f53\u8bb0\u5f55\uff0cfilePath\uff1a" + entity.getFilePath());
            FileUtil.deleteFile(targetFile);
            this.deleteEntity(needRemoveEntity, filePath);
            return;
        }
        DbEntity.deleteData(ThreadRecord.class, "taskKey=? AND threadType=?", filePath, String.valueOf(entity.getTaskType()));
        DbEntity.deleteData(TaskRecord.class, "filePath=? AND taskType=?", filePath, String.valueOf(entity.getTaskType()));
        if (needRemoveFile || !entity.isComplete()) {
            FileUtil.deleteFile(targetFile);
            if (record.isBlock) {
                this.removeBlockFile(record);
            }
        }
        this.deleteEntity(needRemoveEntity, filePath);
    }

    private void deleteEntity(boolean needRemoveEntity, String filePath) {
        if (needRemoveEntity) {
            DbEntity.deleteData(DownloadEntity.class, "downloadPath=?", filePath);
        }
    }

    private void removeBlockFile(TaskRecord record) {
        int len = record.threadNum;
        for (int i = 0; i < len; ++i) {
            FileUtil.deleteFile(String.format("%s.%s.part", record.filePath, i));
        }
    }
}

