/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.text.TextUtils;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.wrapper.RecordWrapper;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.DbDataHelper;
import com.arialyy.aria.util.FileUtil;
import com.arialyy.aria.util.IDeleteRecord;
import java.util.List;

public class DeleteDGRecord
implements IDeleteRecord {
    private String TAG = CommonUtil.getClassName(this);
    private static volatile DeleteDGRecord INSTANCE = null;

    private DeleteDGRecord() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeleteDGRecord getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DeleteDGRecord> clazz = DeleteDGRecord.class;
        synchronized (DeleteDGRecord.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DeleteDGRecord();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public void deleteRecord(String dirPath, boolean needRemoveFile, boolean needRemoveEntity) {
        if (TextUtils.isEmpty((CharSequence)dirPath)) {
            ALog.e(this.TAG, "\u5220\u9664\u4e0b\u8f7d\u4efb\u52a1\u7ec4\u8bb0\u5f55\u5931\u8d25\uff0c\u7ec4\u5408\u4efb\u52a1\u8def\u5f84\u4e3a\u7a7a");
            return;
        }
        this.deleteRecord(DbDataHelper.getDGEntityByPath(dirPath), needRemoveFile, needRemoveEntity);
    }

    @Override
    public void deleteRecord(AbsEntity absEntity, boolean needRemoveFile, boolean needRemoveEntity) {
        if (absEntity == null) {
            ALog.e(this.TAG, "\u5220\u9664\u7ec4\u5408\u4efb\u52a1\u8bb0\u5f55\u5931\u8d25\uff0c\u7ec4\u5408\u4efb\u52a1\u5b9e\u4f53\u4e3a\u7a7a");
            return;
        }
        DownloadGroupEntity groupEntity = (DownloadGroupEntity)absEntity;
        List<RecordWrapper> records = DbEntity.findRelationData(RecordWrapper.class, "dGroupHash=?", groupEntity.getGroupHash());
        if (records == null || records.isEmpty()) {
            ALog.w(this.TAG, "\u7ec4\u4efb\u52a1\u8bb0\u5f55\u5df2\u5220\u9664");
        } else {
            for (RecordWrapper record : records) {
                if (record == null || record.taskRecord == null) continue;
                if (record.taskRecord.isBlock) {
                    this.removeBlockFile(record.taskRecord);
                }
                DbEntity.deleteData(ThreadRecord.class, "taskKey=?", record.taskRecord.filePath);
                record.taskRecord.deleteData();
            }
        }
        List<DownloadEntity> subs = groupEntity.getSubEntities();
        if (subs != null) {
            for (DownloadEntity sub : subs) {
                if (!needRemoveFile && groupEntity.isComplete()) continue;
                FileUtil.deleteFile(sub.getFilePath());
            }
        }
        if (!(TextUtils.isEmpty((CharSequence)groupEntity.getDirPath()) || !needRemoveFile && groupEntity.isComplete())) {
            FileUtil.deleteFile(groupEntity.getDirPath());
        }
        this.deleteEntity(needRemoveEntity, groupEntity.getGroupHash());
    }

    private void deleteEntity(boolean needRemoveEntity, String groupHash) {
        if (needRemoveEntity) {
            DbEntity.deleteData(DownloadEntity.class, "groupHash=?", groupHash);
            DbEntity.deleteData(DownloadGroupEntity.class, "groupHash=?", groupHash);
        }
    }

    private void removeBlockFile(TaskRecord record) {
        int len = record.threadNum;
        for (int i = 0; i < len; ++i) {
            FileUtil.deleteFile(String.format("%s.%s.part", record.filePath, i));
        }
    }
}

