/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.os.Handler;
import com.arialyy.aria.core.TaskOptionParams;
import com.arialyy.aria.core.inf.IEventHandler;
import com.arialyy.aria.core.inf.ITaskOption;
import com.arialyy.aria.core.inf.IUtil;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.task.AbsTask;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.exception.AriaComponentException;
import com.arialyy.aria.util.AriaServiceLoader;
import com.arialyy.aria.util.CommonUtil;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.List;

public class ComponentUtil {
    public static final int COMPONENT_TYPE_HTTP = 1;
    public static final int COMPONENT_TYPE_FTP = 2;
    public static final int COMPONENT_TYPE_M3U8 = 3;
    public static final int COMPONENT_TYPE_SFTP = 4;
    private String TAG = CommonUtil.getClassName(this.getClass());
    private static volatile ComponentUtil INSTANCE = null;
    private AriaServiceLoader<IUtil> utilLoader = AriaServiceLoader.load(IUtil.class);
    private AriaServiceLoader<IEventListener> listenerLoader = AriaServiceLoader.load(IEventListener.class);

    private ComponentUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ComponentUtil getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ComponentUtil> clazz = ComponentUtil.class;
        synchronized (ComponentUtil.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ComponentUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public boolean checkComponentExist(int componentType) {
        String errorStr = "";
        String className = null;
        switch (componentType) {
            case 3: {
                className = "com.arialyy.aria.m3u8.M3U8TaskOption";
                errorStr = "m3u8\u63d2\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6dfb\u52a0m3u8\u63d2\u4ef6";
                break;
            }
            case 2: {
                className = "com.arialyy.aria.ftp.FtpTaskOption";
                errorStr = "ftp\u63d2\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6dfb\u52a0ftp\u63d2\u4ef6";
                break;
            }
            case 1: {
                className = "com.arialyy.aria.http.HttpTaskOption";
                errorStr = "http\u63d2\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6dfb\u52a0http\u63d2\u4ef6";
                break;
            }
            case 4: {
                className = "com.arialyy.aria.sftp.SFtpTaskOption";
                errorStr = "sftp\u63d2\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6dfb\u52a0sftp\u63d2\u4ef6";
            }
        }
        try {
            this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(errorStr);
        }
        return true;
    }

    public synchronized IUtil buildUtil(AbsTaskWrapper wrapper, IEventListener listener) {
        int requestType = wrapper.getRequestType();
        String className = null;
        switch (requestType) {
            case 8: {
                className = "com.arialyy.aria.m3u8.live.M3U8LiveUtil";
                break;
            }
            case 7: {
                className = "com.arialyy.aria.m3u8.vod.M3U8VodUtil";
                break;
            }
            case 3: {
                className = "com.arialyy.aria.ftp.download.FtpDLoaderUtil";
                break;
            }
            case 1: {
                className = "com.arialyy.aria.http.download.HttpDLoaderUtil";
                break;
            }
            case 6: {
                className = "com.arialyy.aria.ftp.upload.FtpULoaderUtil";
                break;
            }
            case 5: {
                className = "com.arialyy.aria.http.upload.HttpULoaderUtil";
                break;
            }
            case 4: {
                className = "com.arialyy.aria.ftp.download.FtpDGLoaderUtil";
                break;
            }
            case 2: {
                className = "com.arialyy.aria.http.download.HttpDGLoaderUtil";
                break;
            }
            case 12: {
                className = "com.arialyy.aria.sftp.download.SFtpDLoaderUtil";
                break;
            }
            case 13: {
                className = "com.arialyy.aria.sftp.upload.SFtpULoaderUtil";
            }
        }
        IUtil util = this.utilLoader.getService(className);
        if (util == null) {
            throw new AriaComponentException("\u52a0\u8f7d\u5de5\u5177\u5f02\u5e38\uff0c\u8bf7\u6c42\u7c7b\u578b\uff1a" + wrapper.getRequestType());
        }
        return util.setParams(wrapper, listener);
    }

    public synchronized IEventListener buildListener(int wrapperType, AbsTask task, Handler outHandler) {
        String className = null;
        String errorStr = "\u8bf7\u6dfb\u52a0FTP\u63d2\u4ef6";
        switch (wrapperType) {
            case 7: 
            case 8: {
                className = "com.arialyy.aria.m3u8.M3U8Listener";
                errorStr = "\u8bf7\u6dfb\u52a0m3u8\u63d2\u4ef6";
                break;
            }
            case 1: 
            case 3: 
            case 12: {
                className = "com.arialyy.aria.core.listener.BaseDListener";
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                className = "com.arialyy.aria.core.listener.BaseUListener";
                break;
            }
            case 2: 
            case 4: {
                className = "com.arialyy.aria.core.listener.DownloadGroupListener";
            }
        }
        if (className == null) {
            return null;
        }
        IEventListener listener = this.listenerLoader.getService(className);
        if (listener == null) {
            throw new AriaComponentException(errorStr);
        }
        return listener.setParams(task, outHandler);
    }

    public synchronized <T extends ITaskOption> T buildTaskOption(Class<T> clazz, TaskOptionParams params) {
        List<Field> fields = CommonUtil.getAllFields(clazz);
        ITaskOption taskOption = null;
        try {
            taskOption = (ITaskOption)clazz.newInstance();
            for (Field field : fields) {
                field.setAccessible(true);
                Class<?> type = field.getType();
                String key = field.getName();
                if (type != SoftReference.class) {
                    Object obj = params.getParams().get(key);
                    if (obj == null) continue;
                    field.set(taskOption, obj);
                    continue;
                }
                IEventHandler handler = params.getHandler().get(key);
                if (handler == null) continue;
                field.set(taskOption, new SoftReference<IEventHandler>(handler));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return (T)taskOption;
    }
}

