/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceConfigurationError;

public class AriaServiceLoader<S> {
    private static final String PREFIX = "META-INF/services/";
    private final Class<S> service;
    private final ClassLoader loader;
    private LazyLoader lazyLoader;

    public void reload() {
        this.lazyLoader = new LazyLoader(this.service, this.loader);
    }

    private AriaServiceLoader(Class<S> svc, ClassLoader cl) {
        this.service = svc;
        this.loader = cl == null ? ClassLoader.getSystemClassLoader() : cl;
        this.reload();
    }

    public static <S> AriaServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new AriaServiceLoader<S>(service, loader);
    }

    public static <S> AriaServiceLoader<S> load(Class<S> service) {
        Thread.currentThread().setContextClassLoader(AriaServiceLoader.class.getClassLoader());
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return AriaServiceLoader.load(service, cl);
    }

    public S getService(String serviceName) {
        return (S)this.lazyLoader.loadService(serviceName);
    }

    private class LazyLoader {
        private Class<S> service;
        private ClassLoader loader;
        private Enumeration<URL> configs = null;
        private List<String> pending = null;

        private LazyLoader(Class<S> service, ClassLoader loader) {
            this.service = service;
            this.loader = loader;
            this.parseConfig();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> parse(Class<?> service, URL u) throws ServiceConfigurationError {
            InputStream in = null;
            BufferedReader r = null;
            ArrayList<String> names = new ArrayList<String>();
            try {
                in = u.openStream();
                r = new BufferedReader(new InputStreamReader(in, "utf-8"));
                int lc = 1;
                while ((lc = this.parseLine(service, u, r, lc, names)) >= 0) {
                }
            }
            catch (IOException x) {
                this.fail(service, "Error reading configuration file", x);
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException y) {
                    this.fail(service, "Error closing configuration file", y);
                }
            }
            return names;
        }

        private void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
            throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
        }

        private void fail(Class<?> service, String msg) throws ServiceConfigurationError {
            throw new ServiceConfigurationError(service.getName() + ": " + msg);
        }

        private void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
            this.fail(service, u + ":" + line + ": " + msg);
        }

        private int parseLine(Class<?> service, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
            int n;
            String ln = r.readLine();
            if (ln == null) {
                return -1;
            }
            int ci = ln.indexOf(35);
            if (ci >= 0) {
                ln = ln.substring(0, ci);
            }
            if ((n = (ln = ln.trim()).length()) != 0) {
                int cp;
                if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                    this.fail(service, u, lc, "Illegal configuration-file syntax");
                }
                if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                    this.fail(service, u, lc, "Illegal provider-class name: " + ln);
                }
                for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                    cp = ln.codePointAt(i);
                    if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                    this.fail(service, u, lc, "Illegal provider-class name: " + ln);
                }
                if (!names.contains(ln)) {
                    names.add(ln);
                }
            }
            return lc + 1;
        }

        private S loadService(String serviceName) {
            for (String s : this.pending) {
                if (!s.equals(serviceName)) continue;
                Class<?> c = null;
                try {
                    c = Class.forName(serviceName, false, this.loader);
                }
                catch (ClassNotFoundException x) {
                    this.fail(this.service, "Provider " + serviceName + " not found", x);
                }
                if (!this.service.isAssignableFrom(c)) {
                    ClassCastException cce = new ClassCastException(this.service.getCanonicalName() + " is not assignable from " + c.getCanonicalName());
                    this.fail(this.service, "Provider " + serviceName + " not a subtype", cce);
                }
                try {
                    return this.service.cast(c.newInstance());
                }
                catch (Throwable x) {
                    this.fail(this.service, "Provider " + serviceName + " could not be instantiated", x);
                }
            }
            throw new Error();
        }

        private void parseConfig() {
            if (this.configs == null) {
                try {
                    String fullName = AriaServiceLoader.PREFIX + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
                }
                catch (IOException x) {
                    this.fail(this.service, "Error locating configuration files", x);
                }
            }
            while (this.pending == null || this.pending.isEmpty()) {
                if (!this.configs.hasMoreElements()) {
                    return;
                }
                this.pending = this.parse(this.service, this.configs.nextElement());
            }
        }
    }
}

